/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.crypto;

import ch.epfl.dedis.lib.crypto.Bn256G1Point;
import ch.epfl.dedis.lib.crypto.Bn256G2Point;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.crypto.bn256.BN;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class BlsSig {
    private byte[] sig;

    BlsSig(byte[] sig) {
        this.sig = sig;
    }

    public boolean verify(byte[] msg, Bn256G2Point X) {
        Bn256G1Point HM = BlsSig.hashToPoint(msg);
        BN.GT left = HM.pair(X);
        try {
            Bn256G1Point s = new Bn256G1Point(this.sig);
            if (s.g1 == null) {
                return false;
            }
            BN.GT right = s.pair(new Bn256G2Point(BigInteger.ONE));
            return left.equals(right);
        }
        catch (CothorityCryptoException e) {
            return false;
        }
    }

    public static BlsSig sign(Scalar x, byte[] msg) {
        Bn256G1Point HM = BlsSig.hashToPoint(msg);
        Point xHM = HM.mul(x);
        return new BlsSig(xHM.toBytes());
    }

    public byte[] getSig() {
        return this.sig;
    }

    private static Bn256G1Point hashToPoint(byte[] msg) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(msg);
            BigInteger scalar = new BigInteger(1, digest.digest());
            return new Bn256G1Point(scalar);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

