/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.crypto;

import ch.epfl.dedis.lib.Hex;
import ch.epfl.dedis.lib.crypto.Bn256G2Point;
import ch.epfl.dedis.lib.crypto.Bn256Scalar;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.crypto.bn256.BN;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.Arrays;

public class Bn256G1Point
implements Point {
    static final byte[] marshalID = "bn256.g1".getBytes();
    BN.G1 g1;

    Bn256G1Point(BigInteger scalar) {
        this.g1 = new BN.G1();
        this.g1.scalarBaseMul(scalar);
    }

    Bn256G1Point(String pubkey) throws CothorityCryptoException {
        this(Hex.parseHexBinary(pubkey));
    }

    Bn256G1Point(byte[] b) throws CothorityCryptoException {
        if (Arrays.equals(marshalID, Arrays.copyOfRange(b, 0, 8))) {
            b = Arrays.copyOfRange(b, 8, b.length);
        }
        this.g1 = new BN.G1();
        if (this.g1.unmarshal(b) == null) {
            throw new CothorityCryptoException("invalid buffer");
        }
    }

    Bn256G1Point(BN.G1 g1) {
        this.g1 = new BN.G1(g1);
    }

    @Override
    public Point copy() {
        return new Bn256G1Point(this.g1);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Bn256G1Point)) {
            return false;
        }
        return Arrays.equals(((Bn256G1Point)other).toBytes(), this.toBytes());
    }

    @Override
    public Point mul(Scalar s) {
        if (!(s instanceof Bn256Scalar)) {
            throw new UnsupportedOperationException();
        }
        BigInteger k = new BigInteger(1, s.getBigEndian());
        BN.G1 p = new BN.G1();
        p.scalarMul(this.g1, k);
        return new Bn256G1Point(p);
    }

    @Override
    public Point add(Point other) {
        if (!(other instanceof Bn256G1Point)) {
            throw new UnsupportedOperationException();
        }
        BN.G1 p = new BN.G1();
        p.add(this.g1, ((Bn256G1Point)other).g1);
        return new Bn256G1Point(p);
    }

    @Override
    public ByteString toProto() {
        ByteString id = ByteString.copyFrom((byte[])marshalID);
        return id.concat(ByteString.copyFrom((byte[])this.toBytes()));
    }

    @Override
    public byte[] toBytes() {
        return this.g1.marshal();
    }

    @Override
    public boolean isZero() {
        return this.g1.isInfinity();
    }

    @Override
    public Point negate() {
        BN.G1 p = new BN.G1();
        p.neg(this.g1);
        return new Bn256G1Point(p);
    }

    @Override
    public byte[] data() {
        return this.g1.marshal();
    }

    @Override
    public String toString() {
        return this.g1.toString();
    }

    @Override
    public Point getZero() {
        BN.G1 p = new BN.G1();
        p.setInfinity();
        return new Bn256G1Point(p);
    }

    public BN.GT pair(Bn256G2Point g2) {
        return BN.pair(this.g1, g2.g2);
    }
}

