/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.crypto;

import ch.epfl.dedis.lib.Hex;
import ch.epfl.dedis.lib.crypto.Ed25519;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ed25519Point
implements Point {
    static final byte[] marshalID = "ed.point".getBytes();
    private static final Logger logger = LoggerFactory.getLogger(Ed25519Point.class);
    private GroupElement element;

    Ed25519Point(byte[] b) throws CothorityCryptoException {
        if (b.length != 40 && b.length != 32) {
            throw new CothorityCryptoException("Wrong Edward25519 format");
        }
        if (Arrays.equals(marshalID, Arrays.copyOfRange(b, 0, 8))) {
            b = Arrays.copyOfRange(b, 8, b.length);
        }
        this.element = new GroupElement(Ed25519.curve, b);
    }

    Ed25519Point(String str) throws CothorityCryptoException {
        this(Hex.parseHexBinary(str));
    }

    Ed25519Point(Point p) {
        this(Ed25519Point.convert((Point)p).element);
    }

    Ed25519Point(GroupElement e) {
        this.element = e;
    }

    @Override
    public Point copy() {
        return new Ed25519Point(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Ed25519Point)) {
            return false;
        }
        return Arrays.equals(this.element.toByteArray(), Ed25519Point.convert((Point)((Ed25519Point)other)).element.toByteArray());
    }

    @Override
    public Point mul(Scalar s) {
        this.element = this.element.toP3();
        this.element.precompute(true);
        return new Ed25519Point(this.element.scalarMultiply(s.getLittleEndian()));
    }

    @Override
    public Point add(Point other) {
        Ed25519Point p = Ed25519Point.convert(other);
        return new Ed25519Point(this.element.toP3().add(p.element.toCached()));
    }

    @Override
    public ByteString toProto() {
        return ByteString.copyFrom((byte[])marshalID).concat(ByteString.copyFrom((byte[])this.toBytes()));
    }

    @Override
    public byte[] toBytes() {
        return this.element.toByteArray();
    }

    @Override
    public boolean isZero() {
        return this.element.equals((Object)Ed25519.curve.getZero(GroupElement.Representation.P3));
    }

    @Override
    public Point getZero() {
        return new Ed25519Point(Ed25519.curve.getZero(GroupElement.Representation.P3));
    }

    @Override
    public String toString() {
        return Hex.printHexBinary(this.toBytes());
    }

    public EdDSAPublicKey toEdDSAPub() {
        EdDSAPublicKeySpec spec = new EdDSAPublicKeySpec(this.element, (EdDSAParameterSpec)Ed25519.ed25519);
        return new EdDSAPublicKey(spec);
    }

    @Override
    public Point negate() {
        return new Ed25519Point(this.element.toP3().negate());
    }

    @Override
    public byte[] data() throws CothorityCryptoException {
        byte[] bytes = this.toBytes();
        byte len = bytes[0];
        if (len > 30 || len < 0) {
            logger.info(Hex.printHexBinary(bytes));
            throw new CothorityCryptoException("doesn't seem to be a valid point");
        }
        return Arrays.copyOfRange(bytes, 1, len + 1);
    }

    public static Point embed(byte[] data) throws CothorityCryptoException {
        if (data.length > 30) {
            throw new CothorityCryptoException("too much data for point");
        }
        byte[] bytes = new byte[32];
        bytes[0] = (byte)data.length;
        System.arraycopy(data, 0, bytes, 1, data.length);
        bytes[31] = 0;
        while (bytes[31] < 127) {
            try {
                Ed25519Point e = new Ed25519Point(bytes);
                if (e.mul(Ed25519.prime_order).isZero()) {
                    return e;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            bytes[31] = (byte)(bytes[31] + 1);
        }
        throw new CothorityCryptoException("did not find matching point!?!");
    }

    public static Point base() {
        return Ed25519.base;
    }

    private static Ed25519Point convert(Point p) {
        if (!(p instanceof Ed25519Point)) {
            throw new IllegalArgumentException(String.format("Error thrown because you are trying to operate an Ed25519Point with a Point implementing class %s", p.getClass().getName()));
        }
        return (Ed25519Point)p;
    }
}

