/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.crypto;

import ch.epfl.dedis.lib.Hex;
import ch.epfl.dedis.lib.crypto.Ed25519;
import ch.epfl.dedis.lib.crypto.Scalar;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.math.FieldElement;
import net.i2p.crypto.eddsa.math.ed25519.Ed25519ScalarOps;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;

public class Ed25519Scalar
implements Scalar {
    public FieldElement fieldElement;

    public Ed25519Scalar(String str) {
        this(str, true);
    }

    public Ed25519Scalar(String str, boolean reduce) {
        this(Hex.parseHexBinary(str), reduce);
    }

    public Ed25519Scalar(byte[] b) {
        this(b, true);
    }

    public Ed25519Scalar(byte[] b, boolean reduce) {
        if (reduce) {
            byte[] reduced = new Ed25519ScalarOps().reduce(Arrays.copyOfRange(b, 0, 64));
            this.fieldElement = Ed25519.field.fromByteArray(reduced);
        } else {
            this.fieldElement = Ed25519.field.fromByteArray(b);
        }
    }

    public Ed25519Scalar(FieldElement f) {
        this.fieldElement = f;
    }

    @Override
    public String toString() {
        return Hex.printHexBinary(this.getLittleEndian());
    }

    @Override
    public ByteString toProto() {
        return ByteString.copyFrom((byte[])this.reduce().getLittleEndian());
    }

    @Override
    public byte[] toBytes() {
        return this.reduce().getLittleEndian();
    }

    @Override
    public Scalar reduce() {
        return new Ed25519Scalar(Ed25519.ed25519.getScalarOps().reduce(this.getLittleEndianFull()));
    }

    @Override
    public Scalar copy() {
        return new Ed25519Scalar(this.getLittleEndian());
    }

    @Override
    public boolean equals(Scalar other) {
        Ed25519Scalar s = Ed25519Scalar.convert(other);
        return Arrays.equals(this.fieldElement.toByteArray(), s.fieldElement.toByteArray());
    }

    @Override
    public Scalar addOne() {
        return new Ed25519Scalar(this.fieldElement.addOne());
    }

    @Override
    public byte[] getBigEndian() {
        return Ed25519.reverse(this.getLittleEndian());
    }

    @Override
    public byte[] getLittleEndian() {
        return this.fieldElement.toByteArray();
    }

    @Override
    public Scalar add(Scalar b) {
        Ed25519Scalar other = Ed25519Scalar.convert(b);
        return new Ed25519Scalar(this.fieldElement.add(other.fieldElement));
    }

    @Override
    public Scalar sub(Scalar b) {
        Ed25519Scalar other = Ed25519Scalar.convert(b);
        return new Ed25519Scalar(this.fieldElement.subtract(other.fieldElement));
    }

    @Override
    public Scalar invert() {
        return new Ed25519Scalar(this.fieldElement.invert());
    }

    @Override
    public Scalar negate() {
        return Ed25519Scalar.convert(Ed25519.prime_order).sub(this.reduce()).reduce();
    }

    @Override
    public boolean isZero() {
        return !Ed25519Scalar.convert((Scalar)this.reduce()).fieldElement.isNonZero();
    }

    @Override
    public Scalar mul(Scalar s) {
        Ed25519Scalar other = Ed25519Scalar.convert(s);
        return new Ed25519Scalar(Ed25519.ed25519.getScalarOps().multiplyAndAdd(this.fieldElement.toByteArray(), other.fieldElement.toByteArray(), Ed25519.field.ZERO.toByteArray()));
    }

    public EdDSAPrivateKey getPrivate() {
        EdDSAPrivateKeySpec spec = new EdDSAPrivateKeySpec((EdDSAParameterSpec)Ed25519.ed25519, this.getLittleEndianFull());
        return new EdDSAPrivateKey(spec);
    }

    private static Ed25519Scalar convert(Scalar s) {
        if (!(s instanceof Ed25519Scalar)) {
            throw new IllegalArgumentException(String.format("Error thrown because you are trying to operate an Ed25519Scalar with a Scalar implementing class %s", s.getClass().getName()));
        }
        return (Ed25519Scalar)s;
    }

    private byte[] getLittleEndianFull() {
        return Arrays.copyOfRange(this.getLittleEndian(), 0, 64);
    }
}

