/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.crypto;

import ch.epfl.dedis.lib.crypto.Bn256G2Point;
import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointFactory {
    static final String SUITE_ED25519 = "Ed25519";
    static final String SUITE_BN256 = "bn256.adapter";
    private static final Logger logger = LoggerFactory.getLogger(Ed25519Point.class);
    private static final PointFactory INSTANCE = new PointFactory();
    private Map<Tag, PointGenerator> tags = new HashMap<Tag, PointGenerator>();

    public static PointFactory getInstance() {
        return INSTANCE;
    }

    private PointFactory() {
        this.tags.put(new Tag(Bn256G2Point.marshalID), Bn256G2Point::new);
        this.tags.put(new Tag(Ed25519Point.marshalID), Ed25519Point::new);
    }

    public Point fromProto(ByteString pubkey) {
        byte[] buf = Arrays.copyOfRange(pubkey.toByteArray(), 0, 8);
        Tag tag = new Tag(buf);
        if (this.tags.containsKey(tag)) {
            try {
                return this.tags.get(tag).make(pubkey.toByteArray());
            }
            catch (CothorityCryptoException e) {
                logger.error(e.getMessage());
            }
        }
        return null;
    }

    public Point fromToml(String suite, String pubhex) {
        try {
            switch (suite) {
                case "Ed25519": {
                    return new Ed25519Point(pubhex);
                }
                case "bn256.adapter": {
                    return new Bn256G2Point(pubhex);
                }
            }
            return null;
        }
        catch (CothorityCryptoException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private class Tag {
        private byte[] tag;

        Tag(byte[] value) {
            this.tag = value;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Tag)) {
                return false;
            }
            return Arrays.equals(this.tag, ((Tag)other).tag);
        }

        public int hashCode() {
            return ByteBuffer.wrap(this.tag).getInt();
        }
    }

    private static interface PointGenerator {
        public Point make(byte[] var1) throws CothorityCryptoException;
    }
}

