/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.crypto.bn256;

import ch.epfl.dedis.lib.crypto.bn256.Constants;
import ch.epfl.dedis.lib.crypto.bn256.CurvePoint;
import ch.epfl.dedis.lib.crypto.bn256.GFp12;
import ch.epfl.dedis.lib.crypto.bn256.OptAte;
import ch.epfl.dedis.lib.crypto.bn256.TwistPoint;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;

public class BN {
    public static BigInteger order = Constants.order;

    public static GT pair(G1 g1, G2 g2) {
        return new GT(OptAte.optimalAte(g2.p, g1.p));
    }

    static BigInteger randPosBigInt(Random rnd, BigInteger n) {
        BigInteger r;
        while ((r = new BigInteger(n.bitLength(), rnd)).signum() <= 0 || r.compareTo(n) >= 0) {
        }
        return r;
    }

    static byte[] bigIntegerToBytes(BigInteger a) {
        byte[] bytes = a.toByteArray();
        if (bytes[0] == 0) {
            return Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        return bytes;
    }

    public static class GT {
        GFp12 p;

        public GT() {
            this.p = new GFp12();
        }

        public GT(GFp12 p) {
            this.p = p;
        }

        public String toString() {
            return "bn256.GT" + this.p.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof GT)) {
                return false;
            }
            GT other = (GT)obj;
            return other.p.equals(this.p);
        }

        public GT scalarMul(GT a, BigInteger k) {
            this.p.exp(a.p, k);
            return this;
        }

        public GT add(GT a, GT b) {
            this.p.mul(a.p, b.p);
            return this;
        }

        public GT neg(GT a) {
            this.p.invert(a.p);
            return this;
        }

        public byte[] marshal() {
            this.p.minimal();
            byte[] xxxBytes = BN.bigIntegerToBytes(this.p.x.x.x);
            byte[] xxyBytes = BN.bigIntegerToBytes(this.p.x.x.y);
            byte[] xyxBytes = BN.bigIntegerToBytes(this.p.x.y.x);
            byte[] xyyBytes = BN.bigIntegerToBytes(this.p.x.y.y);
            byte[] xzxBytes = BN.bigIntegerToBytes(this.p.x.z.x);
            byte[] xzyBytes = BN.bigIntegerToBytes(this.p.x.z.y);
            byte[] yxxBytes = BN.bigIntegerToBytes(this.p.y.x.x);
            byte[] yxyBytes = BN.bigIntegerToBytes(this.p.y.x.y);
            byte[] yyxBytes = BN.bigIntegerToBytes(this.p.y.y.x);
            byte[] yyyBytes = BN.bigIntegerToBytes(this.p.y.y.y);
            byte[] yzxBytes = BN.bigIntegerToBytes(this.p.y.z.x);
            byte[] yzyBytes = BN.bigIntegerToBytes(this.p.y.z.y);
            int numBytes = 32;
            byte[] ret = new byte[384];
            System.arraycopy(xxxBytes, 0, ret, 32 - xxxBytes.length, xxxBytes.length);
            System.arraycopy(xxyBytes, 0, ret, 64 - xxyBytes.length, xxyBytes.length);
            System.arraycopy(xyxBytes, 0, ret, 96 - xyxBytes.length, xyxBytes.length);
            System.arraycopy(xyyBytes, 0, ret, 128 - xyyBytes.length, xyyBytes.length);
            System.arraycopy(xzxBytes, 0, ret, 160 - xzxBytes.length, xzxBytes.length);
            System.arraycopy(xzyBytes, 0, ret, 192 - xzyBytes.length, xzyBytes.length);
            System.arraycopy(yxxBytes, 0, ret, 224 - yxxBytes.length, yxxBytes.length);
            System.arraycopy(yxyBytes, 0, ret, 256 - yxyBytes.length, yxyBytes.length);
            System.arraycopy(yyxBytes, 0, ret, 288 - yyxBytes.length, yyxBytes.length);
            System.arraycopy(yyyBytes, 0, ret, 320 - yyyBytes.length, yyyBytes.length);
            System.arraycopy(yzxBytes, 0, ret, 352 - yzxBytes.length, yzxBytes.length);
            System.arraycopy(yzyBytes, 0, ret, 384 - yzyBytes.length, yzyBytes.length);
            return ret;
        }

        public GT unmarshal(byte[] m) {
            int numBytes = 32;
            if (m.length != 384) {
                return null;
            }
            if (this.p == null) {
                this.p = new GFp12();
            }
            this.p.x.x.x = new BigInteger(1, Arrays.copyOfRange(m, 0, 32));
            this.p.x.x.y = new BigInteger(1, Arrays.copyOfRange(m, 32, 64));
            this.p.x.y.x = new BigInteger(1, Arrays.copyOfRange(m, 64, 96));
            this.p.x.y.y = new BigInteger(1, Arrays.copyOfRange(m, 96, 128));
            this.p.x.z.x = new BigInteger(1, Arrays.copyOfRange(m, 128, 160));
            this.p.x.z.y = new BigInteger(1, Arrays.copyOfRange(m, 160, 192));
            this.p.y.x.x = new BigInteger(1, Arrays.copyOfRange(m, 192, 224));
            this.p.y.x.y = new BigInteger(1, Arrays.copyOfRange(m, 224, 256));
            this.p.y.y.x = new BigInteger(1, Arrays.copyOfRange(m, 256, 288));
            this.p.y.y.y = new BigInteger(1, Arrays.copyOfRange(m, 288, 320));
            this.p.y.z.x = new BigInteger(1, Arrays.copyOfRange(m, 320, 352));
            this.p.y.z.y = new BigInteger(1, Arrays.copyOfRange(m, 352, 384));
            return this;
        }
    }

    public static class G2 {
        TwistPoint p;

        public G2() {
            this.p = new TwistPoint();
        }

        public G2(TwistPoint p) {
            this.p = p;
        }

        public G2(G2 p) {
            this.p = new TwistPoint(p.p);
        }

        public G2(BigInteger k) {
            this.p = new TwistPoint().mul(TwistPoint.twistGen, k);
        }

        public static PairG2 rand(Random rnd) {
            BigInteger k = BN.randPosBigInt(rnd, Constants.order);
            G2 p = new G2().scalarBaseMul(k);
            return new PairG2(k, p);
        }

        public String toString() {
            return "bn256.G2" + this.p.toString();
        }

        public G2 scalarBaseMul(BigInteger k) {
            this.p.mul(TwistPoint.twistGen, k);
            return this;
        }

        public G2 scalarMul(G2 a, BigInteger k) {
            this.p.mul(a.p, k);
            return this;
        }

        public G2 add(G2 a, G2 b) {
            this.p.add(a.p, b.p);
            return this;
        }

        public G2 neg(G2 a) {
            this.p.negative(a.p);
            return this;
        }

        public G2 setInfinity() {
            this.p.setInfinity();
            return this;
        }

        public boolean isInfinity() {
            return this.p.isInfinity();
        }

        public byte[] marshal() {
            int numBytes = 32;
            if (this.p.isInfinity()) {
                return new byte[128];
            }
            G2 c = new G2(this);
            c.p.makeAffine();
            byte[] xxBytes = BN.bigIntegerToBytes(c.p.x.x.mod(Constants.p));
            byte[] xyBytes = BN.bigIntegerToBytes(c.p.x.y.mod(Constants.p));
            byte[] yxBytes = BN.bigIntegerToBytes(c.p.y.x.mod(Constants.p));
            byte[] yyBytes = BN.bigIntegerToBytes(c.p.y.y.mod(Constants.p));
            byte[] ret = new byte[128];
            System.arraycopy(xxBytes, 0, ret, 32 - xxBytes.length, xxBytes.length);
            System.arraycopy(xyBytes, 0, ret, 64 - xyBytes.length, xyBytes.length);
            System.arraycopy(yxBytes, 0, ret, 96 - yxBytes.length, yxBytes.length);
            System.arraycopy(yyBytes, 0, ret, 128 - yyBytes.length, yyBytes.length);
            return ret;
        }

        public G2 unmarshal(byte[] m) {
            int numBytes = 32;
            if (m.length != 128) {
                return null;
            }
            if (this.p == null) {
                this.p = new TwistPoint();
            }
            this.p.x.x = new BigInteger(1, Arrays.copyOfRange(m, 0, 32));
            this.p.x.y = new BigInteger(1, Arrays.copyOfRange(m, 32, 64));
            this.p.y.x = new BigInteger(1, Arrays.copyOfRange(m, 64, 96));
            this.p.y.y = new BigInteger(1, Arrays.copyOfRange(m, 96, 128));
            if (this.p.x.x.signum() == 0 && this.p.x.y.signum() == 0 && this.p.y.x.signum() == 0 && this.p.y.y.signum() == 0) {
                this.p.y.setOne();
                this.p.z.setZero();
                this.p.t.setZero();
            } else {
                this.p.z.setOne();
                this.p.t.setOne();
                if (!this.p.isOnCurve()) {
                    return null;
                }
            }
            return this;
        }
    }

    public static class G1 {
        CurvePoint p;

        public G1() {
            this.p = new CurvePoint();
        }

        public G1(CurvePoint p) {
            this.p = p;
        }

        public G1(G1 p) {
            this.p = new CurvePoint(p.p);
        }

        public G1(BigInteger k) {
            this.p = new CurvePoint().mul(CurvePoint.curveGen, k);
        }

        public static PairG1 rand(Random rnd) {
            BigInteger k = BN.randPosBigInt(rnd, Constants.order);
            G1 p = new G1().scalarBaseMul(k);
            return new PairG1(k, p);
        }

        public String toString() {
            return "bn256.G1" + this.p.toString();
        }

        public G1 scalarBaseMul(BigInteger k) {
            this.p.mul(CurvePoint.curveGen, k);
            return this;
        }

        public G1 scalarMul(G1 a, BigInteger k) {
            this.p.mul(a.p, k);
            return this;
        }

        public G1 add(G1 a, G1 b) {
            this.p.add(a.p, b.p);
            return this;
        }

        public G1 neg(G1 a) {
            this.p.negative(a.p);
            return this;
        }

        public G1 setInfinity() {
            this.p.setInfinity();
            return this;
        }

        public boolean isInfinity() {
            return this.p.isInfinity();
        }

        public byte[] marshal() {
            int numBytes = 32;
            G1 c = new G1(this);
            if (c.p.isInfinity()) {
                return new byte[64];
            }
            c.p.makeAffine();
            byte[] xBytes = BN.bigIntegerToBytes(c.p.x.mod(Constants.p));
            byte[] yBytes = BN.bigIntegerToBytes(c.p.y.mod(Constants.p));
            byte[] ret = new byte[64];
            System.arraycopy(xBytes, 0, ret, 32 - xBytes.length, xBytes.length);
            System.arraycopy(yBytes, 0, ret, 64 - yBytes.length, yBytes.length);
            return ret;
        }

        public G1 unmarshal(byte[] m) {
            int numBytes = 32;
            if (m.length != 64) {
                return null;
            }
            this.p.x = new BigInteger(1, Arrays.copyOfRange(m, 0, 32));
            this.p.y = new BigInteger(1, Arrays.copyOfRange(m, 32, 64));
            if (this.p.x.signum() == 0 && this.p.y.signum() == 0) {
                this.p.y = BigInteger.ONE;
                this.p.z = BigInteger.ZERO;
                this.p.t = BigInteger.ZERO;
            } else {
                this.p.z = BigInteger.ONE;
                this.p.t = BigInteger.ONE;
                if (!this.p.isOnCurve()) {
                    return null;
                }
            }
            return this;
        }
    }

    public static class PairG2 {
        private BigInteger k;
        private G2 p;

        public PairG2(BigInteger k, G2 p) {
            this.k = k;
            this.p = p;
        }

        public BigInteger getScalar() {
            return this.k;
        }

        public G2 getPoint() {
            return this.p;
        }
    }

    public static class PairG1 {
        private BigInteger k;
        private G1 p;

        public PairG1(BigInteger k, G1 p) {
            this.k = k;
            this.p = p;
        }

        public BigInteger getScalar() {
            return this.k;
        }

        public G1 getPoint() {
            return this.p;
        }
    }
}

