/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.darc;

import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.PointFactory;
import ch.epfl.dedis.lib.crypto.SchnorrSig;
import ch.epfl.dedis.lib.darc.Identity;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.darc.SignerEd25519;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.DarcProto;

public class IdentityEd25519
implements Identity {
    private Point pub;

    public IdentityEd25519(DarcProto.IdentityEd25519 proto) {
        this.pub = PointFactory.getInstance().fromProto(proto.getPoint());
    }

    public IdentityEd25519(Ed25519Point p) {
        this.pub = p;
    }

    public IdentityEd25519(Signer signer) {
        if (!(signer instanceof SignerEd25519)) {
            throw new RuntimeException("Wrong signer type: " + signer.toString());
        }
        this.pub = signer.getPublic().copy();
    }

    @Override
    public boolean verify(byte[] msg, byte[] signature) {
        try {
            return new SchnorrSig(signature).verify(msg, this.pub);
        }
        catch (CothorityCryptoException e) {
            return false;
        }
    }

    @Override
    public DarcProto.Identity toProto() {
        DarcProto.Identity.Builder bid = DarcProto.Identity.newBuilder();
        DarcProto.IdentityEd25519.Builder bed = DarcProto.IdentityEd25519.newBuilder();
        bed.setPoint(this.pub.toProto());
        bid.setEd25519(bed);
        return bid.build();
    }

    @Override
    public String toString() {
        return String.format("%s:%s", this.typeString(), this.pub.toString().toLowerCase());
    }

    @Override
    public String typeString() {
        return "ed25519";
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof IdentityEd25519)) {
            return false;
        }
        IdentityEd25519 otherEd = (IdentityEd25519)other;
        return this.pub.equals(otherEd.pub);
    }
}

