/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.ClassEntry;
import ch.epfl.scala.debugadapter.ClassSystem;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.SourceDirectory;
import ch.epfl.scala.debugadapter.SourceEntry;
import ch.epfl.scala.debugadapter.SourceJar;
import ch.epfl.scala.debugadapter.StandaloneSourceFile;
import ch.epfl.scala.debugadapter.internal.ClassEntryLookUp;
import ch.epfl.scala.debugadapter.internal.ClassFile;
import ch.epfl.scala.debugadapter.internal.IO$;
import ch.epfl.scala.debugadapter.internal.SanitizedUri;
import ch.epfl.scala.debugadapter.internal.SanitizedUri$;
import ch.epfl.scala.debugadapter.internal.ScalaExtension$;
import ch.epfl.scala.debugadapter.internal.SourceEntryLookUp;
import ch.epfl.scala.debugadapter.internal.SourceEntryLookUp$;
import ch.epfl.scala.debugadapter.internal.SourceFile;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import scala.util.matching.Regex$;

public final class ClassEntryLookUp$ {
    public static ClassEntryLookUp$ MODULE$;

    static {
        new ClassEntryLookUp$();
    }

    public ClassEntryLookUp apply(ClassEntry entry, Logger logger) {
        Seq sourceLookUps = (Seq)entry.sourceEntries().flatMap((Function1 & Serializable & scala.Serializable)x$11 -> Option$.MODULE$.option2Iterable(SourceEntryLookUp$.MODULE$.apply((SourceEntry)x$11, logger)), Seq$.MODULE$.canBuildFrom());
        return this.apply(entry, (Seq<SourceEntryLookUp>)sourceLookUps, logger);
    }

    public ClassEntryLookUp apply(ClassEntry entry, Seq<SourceEntryLookUp> sourceLookUps, Logger logger) {
        Seq classFiles = (Seq)entry.classSystems().flatMap((Function1 & Serializable & scala.Serializable)classSystem -> (Vector)ScalaExtension$.MODULE$.TryExtension(classSystem.within((Function2 & Serializable & scala.Serializable)(fileSystem, root) -> MODULE$.readAllClassFiles((ClassSystem)classSystem, (FileSystem)fileSystem, (Path)root))).warnFailure(logger, new StringBuilder(31).append("Cannot list the class files in ").append(classSystem.name()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty()), Seq$.MODULE$.canBuildFrom());
        Map classNameToClassFile = ((TraversableOnce)classFiles.map((Function1 & Serializable & scala.Serializable)c -> new Tuple2((Object)c.fullyQualifiedName(), c), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map sourceFileToRoot = ((TraversableOnce)sourceLookUps.flatMap((Function1 & Serializable & scala.Serializable)l -> (Seq)l.sourceFiles().map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f), (Object)l.root()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map sourceUriToSourceFile = ((TraversableOnce)((TraversableLike)sourceLookUps.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.sourceFiles(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)new SanitizedUri(SanitizedUri$.MODULE$.apply(f.uri())), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map sourceNameToSourceFile = ((TraversableLike)sourceLookUps.flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.sourceFiles(), Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)f -> f.fileName());
        scala.collection.mutable.Map classNameToSourceFile = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map sourceUriToClassFiles = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Buffer orphanClassFiles = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Buffer missingSourceFileClassFiles = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        classFiles.foreach((Function1 & Serializable & scala.Serializable)classFile -> {
            ClassEntryLookUp$.$anonfun$apply$12(classNameToSourceFile, sourceUriToClassFiles, sourceNameToSourceFile, missingSourceFileClassFiles, sourceFileToRoot, logger, orphanClassFiles, classFile);
            return BoxedUnit.UNIT;
        });
        if (orphanClassFiles.size() > 0) {
            logger.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Found ").append(orphanClassFiles.size()).append(" orphan class files in ").append(entry.name()).toString());
        }
        sourceLookUps.foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        });
        return new ClassEntryLookUp(entry, (Map<String, ClassFile>)classNameToClassFile, (Map<SanitizedUri, SourceFile>)sourceUriToSourceFile, (Map<SanitizedUri, Seq<ClassFile>>)sourceUriToClassFiles.toMap(Predef$.MODULE$.$conforms()), (Map<String, SourceFile>)classNameToSourceFile.toMap(Predef$.MODULE$.$conforms()), (Seq<ClassFile>)missingSourceFileClassFiles.toSeq(), (Seq<ClassFile>)orphanClassFiles.toSeq(), logger);
    }

    private Vector<ClassFile> readAllClassFiles(ClassSystem classSystem, FileSystem fileSystem, Path root) {
        if (Files.exists(root, new LinkOption[0])) {
            PathMatcher classMatcher = fileSystem.getPathMatcher("glob:**.class");
            return ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(Files.walk(root, new FileVisitOption[0]).filter(x$1 -> classMatcher.matches((Path)x$1)).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)path -> MODULE$.readClassFile(classSystem, root, (Path)path)).toVector();
        }
        return package$.MODULE$.Vector().empty();
    }

    private ClassFile readClassFile(ClassSystem classSystem, Path root, Path path) {
        ClassFile classFile;
        BooleanRef isValueClass = BooleanRef.create((boolean)false);
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            ClassReader reader = new ClassReader(inputStream);
            String fullyQualifiedName = reader.getClassName().replace('/', '.');
            ObjectRef sourceName = ObjectRef.create((Object)Option$.MODULE$.empty());
            ClassVisitor visitor = new ClassVisitor(sourceName, isValueClass){
                private final ObjectRef sourceName$1;
                private final BooleanRef isValueClass$1;

                public void visitSource(String source, String debug) {
                    this.sourceName$1.elem = Option$.MODULE$.apply((Object)source);
                }

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    block0: {
                        if (!this.isStatic(access) || !name.endsWith("$extension")) break block0;
                        this.isValueClass$1.elem = true;
                    }
                    return super.visitMethod(access, name, descriptor, signature, exceptions);
                }

                private boolean isStatic(int access) {
                    return (access & 8) != 0;
                }
                {
                    this.sourceName$1 = sourceName$1;
                    this.isValueClass$1 = isValueClass$1;
                    super(589824);
                }
            };
            reader.accept(visitor, 0);
            Path relativePath = root.relativize(path);
            classFile = new ClassFile(fullyQualifiedName, (Option<String>)((Option)sourceName.elem), ((Object)relativePath).toString(), isValueClass.elem, classSystem);
        }
        return classFile;
    }

    private boolean findPackage(SourceFile sourceFile, Path root, String fullPackage, Logger logger) {
        Seq nestedPackages = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(fullPackage)).split('.'))).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(nestedParts, newPart) -> (Seq)((SeqLike)nestedParts.map((Function1 & Serializable & scala.Serializable)outer -> new StringBuilder(1).append((String)outer).append(".").append((String)newPart).toString(), Seq$.MODULE$.canBuildFrom())).$colon$plus(newPart, Seq$.MODULE$.canBuildFrom()));
        Option<String> sourceContent = this.readSourceContent(sourceFile, root, logger);
        return nestedPackages.exists((Function1 & Serializable & scala.Serializable)string -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$findPackage$3(sourceContent, string)));
    }

    public Option<String> ch$epfl$scala$debugadapter$internal$ClassEntryLookUp$$readSourceContent(SourceFile sourceFile, Logger logger) {
        return ScalaExtension$.MODULE$.TryExtension(this.withinSourceEntry(sourceFile.entry(), (Function1 & Serializable & scala.Serializable)x$17 -> MODULE$.readSourceContent(sourceFile, (Path)x$17, logger))).warnFailure(logger, new StringBuilder(23).append("Cannot read content of ").append(sourceFile.uri()).toString()).flatten(Predef$.MODULE$.$conforms());
    }

    private Option<String> readSourceContent(SourceFile sourceFile, Path root, Logger logger) {
        return ScalaExtension$.MODULE$.TryExtension(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Path sourcePath = root.resolve(sourceFile.relativePath());
            return new String(Files.readAllBytes(sourcePath));
        })).warnFailure(logger, new StringBuilder(23).append("Cannot read content of ").append(sourceFile.uri()).toString());
    }

    private <T> Try<T> withinSourceEntry(SourceEntry sourceEntry, Function1<Path, T> f) {
        SourceEntry sourceEntry2 = sourceEntry;
        if (sourceEntry2 instanceof SourceJar) {
            SourceJar sourceJar = (SourceJar)sourceEntry2;
            Path jar = sourceJar.jar();
            return IO$.MODULE$.withinJarFile(jar, (Function1 & Serializable & scala.Serializable)fs -> f.apply((Object)fs.getPath("/", new String[0])));
        }
        if (sourceEntry2 instanceof SourceDirectory) {
            SourceDirectory sourceDirectory = (SourceDirectory)sourceEntry2;
            Path dir = sourceDirectory.directory();
            return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> f.apply((Object)dir));
        }
        if (sourceEntry2 instanceof StandaloneSourceFile) {
            StandaloneSourceFile standaloneSourceFile = (StandaloneSourceFile)sourceEntry2;
            Path absolutePath = standaloneSourceFile.absolutePath();
            return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> f.apply((Object)absolutePath.getParent()));
        }
        throw new MatchError((Object)sourceEntry2);
    }

    private static final void recordSourceFile$1(SourceFile sourceFile, scala.collection.mutable.Map classNameToSourceFile$1, ClassFile classFile$2, scala.collection.mutable.Map sourceUriToClassFiles$1) {
        classNameToSourceFile$1.put((Object)classFile$2.fullyQualifiedName(), (Object)sourceFile);
        sourceUriToClassFiles$1.update((Object)new SanitizedUri(SanitizedUri$.MODULE$.apply(sourceFile.uri())), ((SeqLike)sourceUriToClassFiles$1.getOrElse((Object)new SanitizedUri(SanitizedUri$.MODULE$.apply(sourceFile.uri())), (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).$colon$plus((Object)classFile$2, Seq$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ boolean $anonfun$apply$16(ClassFile classFile$2, SourceFile f) {
        String string = f.folderPath();
        String string2 = classFile$2.folderPath();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$17(SourceFile x$14) {
        return x$14.folderPath().contains("src/");
    }

    public static final /* synthetic */ boolean $anonfun$apply$18(ClassFile classFile$2, SourceFile f) {
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.folderPath().split("src/"))).last();
        String string = classFile$2.fullPackageAsPath();
        return !(object != null ? !object.equals(string) : string != null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$apply$12(scala.collection.mutable.Map classNameToSourceFile$1, scala.collection.mutable.Map sourceUriToClassFiles$1, Map sourceNameToSourceFile$1, Buffer missingSourceFileClassFiles$1, Map sourceFileToRoot$1, Logger logger$2, Buffer orphanClassFiles$1, ClassFile classFile) {
        Option option;
        List list = ((TraversableOnce)classFile.sourceName().flatMap((Function1 & Serializable & scala.Serializable)key -> sourceNameToSourceFile$1.get(key)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).toList();
        if (Nil$.MODULE$.equals(list)) {
            missingSourceFileClassFiles$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClassFile[]{classFile}));
            return;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            SourceFile sourceFile = (SourceFile)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                ClassEntryLookUp$.recordSourceFile$1(sourceFile, classNameToSourceFile$1, classFile, sourceUriToClassFiles$1);
                return;
            }
        }
        if ((option = list.find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$apply$16(classFile, f)))) instanceof Some) {
            Some some = (Some)option;
            SourceFile sourceFile = (SourceFile)some.value();
            ClassEntryLookUp$.recordSourceFile$1(sourceFile, classNameToSourceFile$1, classFile, sourceUriToClassFiles$1);
            return;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        Option option2 = ((LinearSeqOptimized)list.filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$apply$17(x$14)))).find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$apply$18(classFile, f)));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            SourceFile sourceFile = (SourceFile)some.value();
            ClassEntryLookUp$.recordSourceFile$1(sourceFile, classNameToSourceFile$1, classFile, sourceUriToClassFiles$1);
            return;
        }
        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
        List list3 = (List)list.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.MODULE$.findPackage(f, (Path)sourceFileToRoot$1.apply((Object)f), classFile.fullPackage(), logger$2)));
        if (list3 instanceof .colon.colon) {
            .colon.colon colon3 = (.colon.colon)list3;
            SourceFile sourceFile = (SourceFile)colon3.head();
            List list4 = colon3.tl$access$1();
            if (Nil$.MODULE$.equals(list4)) {
                ClassEntryLookUp$.recordSourceFile$1(sourceFile, classNameToSourceFile$1, classFile, sourceUriToClassFiles$1);
                return;
            }
        }
        orphanClassFiles$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClassFile[]{classFile}));
    }

    public static final /* synthetic */ boolean $anonfun$findPackage$4(Regex matcher$1, String x$16) {
        return matcher$1.findFirstIn((CharSequence)x$16).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$findPackage$3(Option sourceContent$1, String string) {
        String quotedPackage = Regex$.MODULE$.quote(string);
        Regex matcher = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(34).append("package\\s+(object\\s+)?").append(quotedPackage).append("(\\{|:|;|\\s+)").toString())).r();
        return sourceContent$1.exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ClassEntryLookUp$.$anonfun$findPackage$4(matcher, x$16)));
    }

    private ClassEntryLookUp$() {
        MODULE$ = this;
    }
}

