/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.Logger;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;

public final class TimeUtils$ {
    public static final TimeUtils$ MODULE$ = new TimeUtils$();

    public <T> T logTime(Logger logger, String msg, Function0<T> f) {
        Tuple2<Duration, T> tuple2 = this.timed(f);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Duration duration = (Duration)tuple2._1();
        Object result = tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)duration, result);
        Duration duration2 = (Duration)tuple22._1();
        Object result2 = tuple22._2();
        logger.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(4).append(msg).append(" in ").append(MODULE$.prettyPrint(duration2)).toString());
        return (T)result2;
    }

    public <T> Tuple2<Duration, T> timed(Function0<T> f) {
        long start = System.currentTimeMillis();
        Object result = f.apply();
        FiniteDuration duration = Duration$.MODULE$.apply(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
        return new Tuple2((Object)duration, result);
    }

    public String prettyPrint(Duration duration) {
        Duration duration2 = duration;
        if (duration2.toSeconds() == 0L) {
            return TimeUtils$.plural$1(duration2.toMillis(), "millisecond");
        }
        if (duration2.toMinutes() == 0L) {
            return TimeUtils$.plural$1(duration2.toSeconds(), "second");
        }
        if (duration2.toHours() == 0L) {
            return TimeUtils$.plural$1(duration2.toMinutes(), "minute");
        }
        if (duration2.toDays() == 0L) {
            return TimeUtils$.plural$1(duration2.toHours(), "hour");
        }
        if (duration2.toDays() < 30L) {
            return TimeUtils$.plural$1(duration2.toDays(), "day");
        }
        if (duration2.toDays() >= 30L && duration2.toDays() <= 365L) {
            return TimeUtils$.plural$1(duration2.toDays() / 30L, "month");
        }
        if (duration2.toDays() > 365L) {
            return TimeUtils$.plural$1(duration2.toDays() / 365L, "year");
        }
        return duration.toString();
    }

    private static final String plural$1(long n, String word) {
        if (n == 1L) {
            return new StringBuilder(2).append("1 ").append(word).toString();
        }
        return new StringBuilder(2).append(n).append(" ").append(word).append("s").toString();
    }

    private TimeUtils$() {
    }
}

