/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.evaluator;

import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.evaluator.Fatal;
import ch.epfl.scala.debugadapter.internal.evaluator.Invalid;
import ch.epfl.scala.debugadapter.internal.evaluator.Recoverable;
import ch.epfl.scala.debugadapter.internal.evaluator.Recoverable$;
import ch.epfl.scala.debugadapter.internal.evaluator.Valid;
import ch.epfl.scala.debugadapter.internal.evaluator.Validation;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMOutOfMemoryException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class Validation$ {
    public static final Validation$ MODULE$ = new Validation$();

    private Invalid handler(Throwable t, Logger logger) {
        Throwable throwable = t;
        if (throwable instanceof VMDisconnectedException ? true : throwable instanceof ObjectCollectedException) {
            return new Fatal(throwable);
        }
        if (throwable instanceof InvalidStackFrameException ? true : throwable instanceof AbsentInformationException) {
            return new Fatal(throwable);
        }
        if (throwable instanceof InvocationException ? true : throwable instanceof VMOutOfMemoryException) {
            return new Fatal(throwable);
        }
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            logger.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Unexpected error while validating: ").append(exception).toString());
            return new Recoverable(exception);
        }
        throw new MatchError((Object)throwable);
    }

    public <A> Validation<A> apply(Function0<A> input, Logger logger) {
        Validation validation;
        block3: {
            try {
                Object value = input.apply();
                if (value == null) {
                    validation = Recoverable$.MODULE$.apply("Found null value, expected non-null value");
                    break block3;
                }
                validation = new Valid<Object>(value);
            }
            catch (Throwable t) {
                validation = (Validation)((Object)this.handler(t, logger));
            }
        }
        return validation;
    }

    public <A> Validation<A> fromOption(Function0<Option<A>> value, String message) {
        Option option = (Option)value.apply();
        if (option instanceof Some) {
            Some some = (Some)option;
            Object value2 = some.value();
            return new Valid<Object>(value2);
        }
        if (None$.MODULE$.equals(option)) {
            return new Recoverable(new NoSuchElementException(message));
        }
        throw new MatchError((Object)option);
    }

    public <A> Validation<A> fromTry(Function0<Try<A>> value, Logger logger) {
        Try try_ = (Try)value.apply();
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object value2 = success.value();
            return new Valid<Object>(value2);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            return (Validation)((Object)this.handler(t, logger));
        }
        throw new MatchError((Object)try_);
    }

    private Validation$() {
    }
}

