/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.channel.Channel;
import ch.ethz.ssh2.channel.ChannelManager;
import ch.ethz.ssh2.channel.IChannelWorkerThread;
import ch.ethz.ssh2.channel.StreamForwarder;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class LocalAcceptThread
extends Thread
implements IChannelWorkerThread {
    ChannelManager cm;
    int local_port;
    String host_to_connect;
    int port_to_connect;
    ServerSocket ss;

    public LocalAcceptThread(ChannelManager cm, int local_port, String host_to_connect, int port_to_connect) {
        this.cm = cm;
        this.local_port = local_port;
        this.host_to_connect = host_to_connect;
        this.port_to_connect = port_to_connect;
    }

    public void run() {
        try {
            this.ss = new ServerSocket(this.local_port);
            this.cm.registerThread(this);
            while (true) {
                Socket s = this.ss.accept();
                Channel cn = this.cm.openDirectTCPIPChannel(this.host_to_connect, this.port_to_connect, s.getInetAddress().getHostAddress(), s.getPort());
                StreamForwarder r2l = new StreamForwarder(cn, null, null, cn.stdoutStream, s.getOutputStream(), "RemoteToLocal");
                StreamForwarder l2r = new StreamForwarder(cn, r2l, s, s.getInputStream(), cn.stdinStream, "LocalToRemote");
                r2l.setDaemon(true);
                l2r.setDaemon(true);
                r2l.start();
                l2r.start();
            }
        }
        catch (IOException e) {
            try {
                if (this.ss != null) {
                    this.ss.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    public void stopWorking() {
        try {
            if (this.ss != null) {
                this.ss.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

