/*
 * Decompiled with CFR 0.152.
 */
package ch.fortysix.maven.plugin.postaman.surfire;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "ch.fortysix:maven-postman-plugin:0.1.6", 0);
        this.append(sb, "", 0);
        this.append(sb, "Postman mail plugin", 0);
        this.append(sb, "Enables sending of mails in a build. The purpose of the plugin is to support conditional emailing (e.g. send an email if a file contains a certain string, the tests failed or just to send a notification or an artifact via mail)", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "postman:help", 0);
            this.append(sb, "Display help information on maven-postman-plugin.\nCall\n\u00a0\u00a0mvn\u00a0postman:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "send-mail".equals(this.goal)) {
            this.append(sb, "postman:send-mail", 0);
            this.append(sb, "Sends a mail with optional attachments.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "failonerror (Default: true)", 2);
                this.append(sb, "flag to indicate whether to halt the build on any error. The default value is true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileSets", 2);
                this.append(sb, "A list of fileSets to be attached to the mail.", 3);
                this.append(sb, "", 0);
                this.append(sb, "from", 2);
                this.append(sb, "Email address of sender.", 3);
                this.append(sb, "", 0);
                this.append(sb, "htmlMessage (Default: <body>build for ${project.groupId}:${project.artifactId}:${project.version} executed</body>)", 2);
                this.append(sb, "The html message body to be send", 3);
                this.append(sb, "", 0);
                this.append(sb, "htmlMessageFile", 2);
                this.append(sb, "The html message body to be send, if set the content of this will replace the htmlMessage.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailAltConfig (Default: false)", 2);
                this.append(sb, "Indicates to use an alternative way to configure the ssl connection to the smtp server. This might be needed in specific environments.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailcontenttype (Default: text/html)", 2);
                this.append(sb, "The content type to use for the message. This is only the fallback contenttype if the environment does not support 'multipart/alternative'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailhost (Default: localhost)", 2);
                this.append(sb, "Host name of the SMTP server. The default value is localhost.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailpassword", 2);
                this.append(sb, "Password for SMTP auth", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailport (Default: 25)", 2);
                this.append(sb, "TCP port of the SMTP server. The default value is 25.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailssl (Default: false)", 2);
                this.append(sb, "Indicates whether you need TLS/SSL", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailuser", 2);
                this.append(sb, "User name for SMTP auth", 3);
                this.append(sb, "", 0);
                this.append(sb, "multipartSupported (Default: true)", 2);
                this.append(sb, "Whether 'multipart/alternative' mails can be send. This is detected automatically, but it allows a user to disable it and force the usage of 'mailcontenttype'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Report output directory. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "receivers", 2);
                this.append(sb, "Who should receive a mail? One can use an id of a developer registered in the pom or an email address directly.\n<receivers>\n<receiver>developerId</receiver>\n<receiver>sam@topland.com</receiver>\n</receivers>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Indicates whether this report should skip the sending mails (no mails send).", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding of the source. Advice is taken from: POM Element for Source File Encoding", 3);
                this.append(sb, "", 0);
                this.append(sb, "subject (Default: [${project.artifactId}])", 2);
                this.append(sb, "Email subject line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "textMessage (Default: build for ${project.groupId}:${project.artifactId}:${project.version} executed)", 2);
                this.append(sb, "The text message to be send", 3);
                this.append(sb, "", 0);
                this.append(sb, "textMessageFile", 2);
                this.append(sb, "The text message body to be send, if set the content of this will replace the textMessage.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "surefire-mail".equals(this.goal)) {
            this.append(sb, "postman:surefire-mail", 0);
            this.append(sb, "Sends mails based on surefire (test) results.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "failonerror (Default: true)", 2);
                this.append(sb, "flag to indicate whether to halt the build on any error. The default value is true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "from", 2);
                this.append(sb, "Email address of sender.", 3);
                this.append(sb, "", 0);
                this.append(sb, "groovyCondition (Default: errors > 0 || failures > 0)", 2);
                this.append(sb, "This allows to redefine the condition to send the mail. e.g. one can define that there must not be more then 20 skipped test cases (skipped > 20). The default condition sends mails if there are any errors. The following variables are available for usage in the condition:\n-\terrors: number of all errors while running surefire\n-\tskipped: number of all skipped test cases\n-\tfailures: number of all failures in the test cases\n-\ttotal: number of all test cases\nOther (usefull or not...) examples:\n-\terrors > 0 : sends a mail only if there are errors\n-\tskipped > failures : sends mails if there are more skipped then failed test cases\n-\ttotal == skipped : Sends mails if all tests are skipped\nTo avoid problems with XML syntax, one can use a CDATA element. The default only send a mail if there are errors or failures, but ignores the skipped ones.", 3);
                this.append(sb, "", 0);
                this.append(sb, "htmlMessage (Default: <body>build for ${project.groupId}:${project.artifactId}:${project.version} executed</body>)", 2);
                this.append(sb, "The html message body to be send", 3);
                this.append(sb, "", 0);
                this.append(sb, "htmlMessageFile", 2);
                this.append(sb, "The html message body to be send, if set the content of this will replace the htmlMessage.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailAltConfig (Default: false)", 2);
                this.append(sb, "Indicates to use an alternative way to configure the ssl connection to the smtp server. This might be needed in specific environments.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailcontenttype (Default: text/html)", 2);
                this.append(sb, "The content type to use for the message. This is only the fallback contenttype if the environment does not support 'multipart/alternative'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailhost (Default: localhost)", 2);
                this.append(sb, "Host name of the SMTP server. The default value is localhost.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailpassword", 2);
                this.append(sb, "Password for SMTP auth", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailport (Default: 25)", 2);
                this.append(sb, "TCP port of the SMTP server. The default value is 25.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailssl (Default: false)", 2);
                this.append(sb, "Indicates whether you need TLS/SSL", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailuser", 2);
                this.append(sb, "User name for SMTP auth", 3);
                this.append(sb, "", 0);
                this.append(sb, "multipartSupported (Default: true)", 2);
                this.append(sb, "Whether 'multipart/alternative' mails can be send. This is detected automatically, but it allows a user to disable it and force the usage of 'mailcontenttype'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Report output directory. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "receivers", 2);
                this.append(sb, "Who should receive a mail? One can use an id of a developer registered in the pom or an email address directly.\n<receivers>\n<receiver>developerId</receiver>\n<receiver>sam@topland.com</receiver>\n</receivers>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportFilePattern (Default: TEST-.*.xml)", 2);
                this.append(sb, "The file pattern to be used to search for the surefire reports in the 'testReportsDirectory'-directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Indicates whether this report should skip the sending mails (no mails send).", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding of the source. Advice is taken from: POM Element for Source File Encoding", 3);
                this.append(sb, "", 0);
                this.append(sb, "subject (Default: [${project.artifactId}])", 2);
                this.append(sb, "Email subject line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "surefireReportHtml (Default: ${project.build.directory}/site/surefire-report.html)", 2);
                this.append(sb, "The generated surefire html report (previously generated by 'maven-surefire-report-plugin').", 3);
                this.append(sb, "", 0);
                this.append(sb, "testReportsDirectory (Default: ${project.build.directory}/surefire-reports)", 2);
                this.append(sb, "Base directory where all surefire test reports are read from.", 3);
                this.append(sb, "", 0);
                this.append(sb, "textMessage (Default: build for ${project.groupId}:${project.artifactId}:${project.version} executed)", 2);
                this.append(sb, "The text message to be send", 3);
                this.append(sb, "", 0);
                this.append(sb, "textMessageFile", 2);
                this.append(sb, "The text message body to be send, if set the content of this will replace the textMessage.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "taglist-mail".equals(this.goal)) {
            this.append(sb, "postman:taglist-mail", 0);
            this.append(sb, "This goal is able to send 'reminder mails' based on the findings of the org.codehaus.mojo:taglist-maven-plugin. One should use at least version 2.4 of the taglist-plugin.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "failonerror (Default: true)", 2);
                this.append(sb, "flag to indicate whether to halt the build on any error. The default value is true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "from", 2);
                this.append(sb, "Email address of sender.", 3);
                this.append(sb, "", 0);
                this.append(sb, "htmlMessage (Default: <body>build for ${project.groupId}:${project.artifactId}:${project.version} executed</body>)", 2);
                this.append(sb, "The html message body to be send", 3);
                this.append(sb, "", 0);
                this.append(sb, "htmlMessageFile", 2);
                this.append(sb, "The html message body to be send, if set the content of this will replace the htmlMessage.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailAltConfig (Default: false)", 2);
                this.append(sb, "Indicates to use an alternative way to configure the ssl connection to the smtp server. This might be needed in specific environments.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailcontenttype (Default: text/html)", 2);
                this.append(sb, "The content type to use for the message. This is only the fallback contenttype if the environment does not support 'multipart/alternative'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailhost (Default: localhost)", 2);
                this.append(sb, "Host name of the SMTP server. The default value is localhost.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailpassword", 2);
                this.append(sb, "Password for SMTP auth", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailport (Default: 25)", 2);
                this.append(sb, "TCP port of the SMTP server. The default value is 25.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailssl (Default: false)", 2);
                this.append(sb, "Indicates whether you need TLS/SSL", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailuser", 2);
                this.append(sb, "User name for SMTP auth", 3);
                this.append(sb, "", 0);
                this.append(sb, "multipartSupported (Default: true)", 2);
                this.append(sb, "Whether 'multipart/alternative' mails can be send. This is detected automatically, but it allows a user to disable it and force the usage of 'mailcontenttype'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Report output directory. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "receivers", 2);
                this.append(sb, "This receivers are interested in any tag found by the taglist-maven-plugin. One can use an id of a developer registered in the pom or an email address directly.\n<receivers>\n<receiver>developerId</receiver>\n<receiver>sam@topland.com</receiver>\n</receivers>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Indicates whether this report should skip the sending mails (no mails send).", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding of the source. Advice is taken from: POM Element for Source File Encoding", 3);
                this.append(sb, "", 0);
                this.append(sb, "subject (Default: [${project.artifactId}])", 2);
                this.append(sb, "Email subject line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagClasses", 2);
                this.append(sb, "Maps the tag class (from taglist plugin) to a list of receivers. The displayName has to match the same from the taglist-maven-plugin configuration. Who should receive a mail? One can use an id of a developer registered in the pom or an email address directly.\n<tagClasses>\n<tagClass>\n<displayName>Todo\u00a0Work</displayName>\n<receivers>\n<receiver>developerId</receiver>\n<receiver>dude@xx.com</receiver>\n</receivers>\n</tagClass>\n</tagClasses>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "taglistReportHtml (Default: ${project.build.directory}/site/taglist.html)", 2);
                this.append(sb, "The generated taglist html report (previously generated by 'taglist-maven-plugin').", 3);
                this.append(sb, "", 0);
                this.append(sb, "taglistReportXml (Default: ${project.build.directory}/taglist/taglist.xml)", 2);
                this.append(sb, "The generated taglist report (previously generated by 'taglist-maven-plugin').", 3);
                this.append(sb, "", 0);
                this.append(sb, "textMessage (Default: build for ${project.groupId}:${project.artifactId}:${project.version} executed)", 2);
                this.append(sb, "The text message to be send", 3);
                this.append(sb, "", 0);
                this.append(sb, "textMessageFile", 2);
                this.append(sb, "The text message body to be send, if set the content of this will replace the textMessage.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

