package ch.hsr.mas.oms.domain.dto;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "accountId",
    "amount",
    "reserved",
    "balance",
    "description",
    "currency"
})
@XmlRootElement(name = "account")
public class Account implements Serializable {

	private static final long serialVersionUID = 164214300563095650L;
	protected int accountId;
	@XmlElement(required = true)
	private double amount;
    private double reserved;
    @XmlElement(required = true)
    protected double balance;
    private String description;
    @XmlElement(required = true)
    protected String currency;

    public int getAccountId() {
        return accountId;
    }

    public void setAccountId(int value) {
        this.accountId = value;
    }

    public double getBalance() {
        return balance;
    }

    public void setBalance(double value) {
        this.balance = value;
    }

	public double getAmount() {
		return amount;
	}

	public void setAmount(double amount) {
		this.amount = amount;
	}

	public double getReserved() {
		return reserved;
	}

	public void setReserved(double reserved) {
		this.reserved = reserved;
	}

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String value) {
        this.currency = value;
    }

    public String toString() {
		   return ReflectionToStringBuilder.toString(this);
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
}
