package ch.hsr.mas.oms.domain.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "header",
    "responseStatus",
    "loginRequest",
    "loginResponse",
    "symbolList",
    "companyList",
    "searchRequest",
    "searchResult",
    "priceBar",
    "orderRequest",
    "orderConfirmation",
    "orderStatusRequest",
    "orderReport",
    "accountRequest",
    "accountDetails",
    "positionRequest",
    "positionDetails",
    "indicatorRequest",
    "indicatorResponse"
})
@XmlRootElement(name = "omsApi")
public class OmsApi implements Serializable {

	private static final long serialVersionUID = -5416292737088864479L;
	@XmlElement
    protected Header header;
    @XmlElement
    protected ResponseStatus responseStatus;
    @XmlElement
    protected LoginRequest loginRequest;
    @XmlElement
    protected LoginResponse loginResponse;
    @XmlElement
    protected SymbolList symbolList;
    @XmlElement
    protected CompanyList companyList;
    @XmlElement
    protected List<SearchRequest> searchRequest;
    @XmlElement
    protected List<SearchResult> searchResult;
    @XmlElement
    protected List<PriceBar> priceBar;
    @XmlElement
    protected OrderRequest orderRequest;
    @XmlElement
    protected OrderConfirmation orderConfirmation;
    @XmlElement
    protected OrderStatusRequest orderStatusRequest;
    @XmlElement
    protected OrderReport orderReport;
    @XmlElement
    protected AccountRequest accountRequest;
    @XmlElement
    protected AccountDetails accountDetails;
    @XmlElement
    protected PositionRequest positionRequest;
    @XmlElement
    protected PositionDetails positionDetails;
    @XmlElement
    protected IndicatorRequest indicatorRequest;
    @XmlElement
    protected IndicatorResponse indicatorResponse;
    @XmlAttribute
    protected String version;

    public Header getHeader() {
        return header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public ResponseStatus getResponseStatus() {
        return responseStatus;
    }

    public void setResponseStatus(ResponseStatus responseStatus) {
        this.responseStatus = responseStatus;
    }

    public void setLoginRequest(LoginRequest loginRequest) {
    	this.loginRequest = loginRequest;
    }

    public LoginRequest getLoginRequest() {
    	return loginRequest;
    }

    public void setLoginResponse(LoginResponse loginResponse) {
    	this.loginResponse = loginResponse;
    }

    public LoginResponse getLoginResponse() {
    	return loginResponse;
    }

    public SymbolList getSymbolList() {
        return symbolList;
    }

    public void setSymbolList(SymbolList symbolList) {
        this.symbolList = symbolList;
    }

    public CompanyList getCompanyList() {
        return companyList;
    }

    public void setCompanyList(CompanyList value) {
        this.companyList = value;
    }

    public List<SearchRequest> getSearchRequest() {
        if (searchRequest == null) {
            searchRequest = new ArrayList<SearchRequest>();
        }
        return this.searchRequest;
    }

    public void setSearchRequest(List<SearchRequest> searchRequest) {
    	this.searchRequest = searchRequest;
    }

    public List<SearchResult> getSearchResult() {
        if (searchResult == null) {
            searchResult = new ArrayList<SearchResult>();
        }
        return this.searchResult;
    }

    public void setSearchResult(List<SearchResult> searchResult) {
    	this.searchResult = searchResult;
    }

    public List<PriceBar> getPriceBars() {
        if (priceBar == null) {
            priceBar = new ArrayList<PriceBar>();
        }
        return this.priceBar;
    }

    public void setPriceBars(List<PriceBar> priceBar) {
    	this.priceBar = priceBar;
    }

    public OrderRequest getOrderRequest() {
        return orderRequest;
    }

    public void setOrderRequest(OrderRequest orderRequest) {
        this.orderRequest = orderRequest;
    }

    public AccountRequest getAccountRequest() {
        return accountRequest;
    }

    public void setAccountRequest(AccountRequest accountRequest) {
        this.accountRequest = accountRequest;
    }

    public AccountDetails getAccountDetails() {
        return accountDetails;
    }

    public void setAccountDetails(AccountDetails accountDetails) {
        this.accountDetails = accountDetails;
    }

    public PositionRequest getPositionRequest() {
        return positionRequest;
    }

    public void setPositionRequest(PositionRequest positionRequest) {
        this.positionRequest = positionRequest;
    }

    public PositionDetails getPositionDetails() {
        return positionDetails;
    }

    public void setPositionDetails(PositionDetails positionDetails) {
        this.positionDetails = positionDetails;
    }

    public OrderConfirmation getOrderConfirmation() {
        return orderConfirmation;
    }

    public void setOrderConfirmation(OrderConfirmation orderConfirmation) {
        this.orderConfirmation = orderConfirmation;
    }

    public OrderStatusRequest getOrderStatusRequest() {
        return orderStatusRequest;
    }

    public void setOrderStatusRequest(OrderStatusRequest orderStatusRequest) {
        this.orderStatusRequest = orderStatusRequest;
    }

    public OrderReport getOrderReport() {
        return orderReport;
    }

    public void setOrderReport(OrderReport orderReport) {
        this.orderReport = orderReport;
    }

    public IndicatorRequest getIndicatorRequest() {
        return indicatorRequest;
    }

    public void setIndicatorRequest(IndicatorRequest indicatorRequest) {
        this.indicatorRequest = indicatorRequest;
    }

    public IndicatorResponse getIndicatorResponse() {
        return indicatorResponse;
    }

    public void setIndicatorResponse(IndicatorResponse indicatorResponse) {
        this.indicatorResponse = indicatorResponse;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
		return ReflectionToStringBuilder.toString(this);
	}
}
