package ch.hsr.mas.oms.domain.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "orderId",
    "symbol",
    "side",
    "orderSize",
    "limitPrice",
    "orderType",
    "timeInForce",
    "orderStatus",
    "filledQty",
    "price",
    "venue",
    "currency",
    "createTs",
    "updateTs",
    "fills"
})
@XmlRootElement(name = "order")
public class Order implements Serializable {

	private static final long serialVersionUID = 3811218748648295087L;
	@XmlElement(required = true)
    protected int orderId;
    @XmlElement(required = true)
    protected String symbol;
    @XmlElement(required = true)
    protected String side;
    @XmlElement(required = true)
    protected int orderSize;
    @XmlElement
    protected double limitPrice;
    @XmlElement(required = true)
    protected String orderType;
    @XmlElement(required = true)
    protected String timeInForce;
    @XmlElement(required = true)
    protected String orderStatus;
    @XmlElement
    protected int filledQty;
    @XmlElement
    protected double price;
    @XmlElement(required = true)
    protected String venue;
    @XmlElement(required = true)
    protected String currency;
    @XmlElement
    protected List<Fill> fills;
    @XmlElement
    protected String createTs;
    @XmlElement
    protected String updateTs;

    public int getOrderId() {
        return orderId;
    }

    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }

    public String getSymbol() {
        return symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSide() {
        return side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public int getOrderSize() {
        return orderSize;
    }

    public void setOrderSize(int orderSize) {
        this.orderSize = orderSize;
    }

    public double getLimitPrice() {
        return limitPrice;
    }

    public void setLimitPrice(double limitPrice) {
        this.limitPrice = limitPrice;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getTimeInForce() {
        return timeInForce;
    }

    public void setTimeInForce(String timeInForce) {
        this.timeInForce = timeInForce;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public int getFilledQty() {
        return filledQty;
    }

    public void setFilledQty(int filledQty) {
        this.filledQty = filledQty;
    }

    public double getPrice() {
        return price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getVenue() {
        return venue;
    }

    public void setVenue(String venue) {
        this.venue = venue;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public List<Fill> getFill() {
        if (fills == null) {
        	fills = new ArrayList<Fill>();
        }
        return this.fills;
    }

    public void setFill(List<Fill> fills) {
    	this.fills = fills;
    }

    public void setCreateTs(String createTs) {
        this.createTs = createTs;
    }

    public String getCreateTs() {
        return createTs;
    }

    public void setUpdateTs(String updateTs) {
        this.updateTs = updateTs;
    }

    public String getupdateTs() {
        return updateTs;
    }

    public String toString() {
		return ReflectionToStringBuilder.toString(this);
	}
}
