package ch.hsr.mas.oms.domain.dto;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
	"orderId",
    "symbol",
    "side",
    "orderSize",
    "limitPrice",
    "orderType",
    "timeInForce",
    "venue",
    "currency",
    "expireDate"
})
@XmlRootElement(name = "orderRequest")
public class OrderRequest implements Serializable {

	private static final long serialVersionUID = -5868180086084566306L;
    private int orderId;
	@XmlElement(required = true)
    protected String symbol;
    @XmlElement(required = true)
    protected String side;
    @XmlElement(required = true)
    protected int orderSize;
    @XmlElement
    protected double limitPrice;
    @XmlElement(required = true)
    protected String orderType;
    @XmlElement(required = true)
    protected String timeInForce;
    @XmlElement(required = true)
    protected String venue;
    @XmlElement(required = true)
    protected String currency;
    @XmlSchemaType(name = "date")
	private XMLGregorianCalendar expireDate;

    public int getOrderId() {
		return orderId;
	}

	public void setOrderId(int orderId) {
		this.orderId = orderId;
	}

	public String getSymbol() {
        return symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSide() {
        return side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public int getOrderSize() {
        return orderSize;
    }

    public void setOrderSize(int orderSize) {
        this.orderSize = orderSize;
    }

    public double getLimitPrice() {
        return limitPrice;
    }

    public void setLimitPrice(double limitPrice) {
        this.limitPrice = limitPrice;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getTimeInForce() {
        return timeInForce;
    }

    public void setTimeInForce(String timeInForce) {
        this.timeInForce = timeInForce;
    }

    public String getVenue() {
        return venue;
    }

    public void setVenue(String venue) {
        this.venue = venue;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public XMLGregorianCalendar getExpireDate() {
		return expireDate;
	}

	public void setExpireDate(XMLGregorianCalendar expireDate) {
		this.expireDate = expireDate;
	}

	public String toString() {
		return ReflectionToStringBuilder.toString(this);
	}
}
