package ch.hsr.mas.oms.domain.dto;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "symbol",
    "name",
    "sector",
    "industry",
    "securityType",
    "venue",
    "currency",
    "last",
    "change",
    "volume",
    "high",
    "low",
    "close",
    "marketCap"
})
@XmlRootElement(name = "searchResult")
public class SearchResult implements Serializable {

	private static final long serialVersionUID = 7440726985432607898L;
	@XmlElement(required = true)
    protected String symbol;
    @XmlElement(required = true)
    protected String name;
    @XmlElement(required = true)
    protected String sector;
    @XmlElement(required = true)
    protected String industry;
    @XmlElement(required = true)
    protected String securityType;
    @XmlElement(required = true)
    protected String venue;
    @XmlElement(required = true)
    protected String currency;
    @XmlElement
    protected Double last;
    @XmlElement
    protected Double change;
    @XmlElement
    protected Integer volume;
    @XmlElement
    protected Double high;
    @XmlElement
    protected Double low;
    @XmlElement
    protected Double close;
    @XmlElement
    protected Double marketCap;

    public String getSymbol() {
        return symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSector() {
        return sector;
    }

    public void setSector(String sector) {
        this.sector = sector;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public String getSecurityType() {
        return securityType;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public String getVenue() {
        return venue;
    }

    public void setVenue(String venue) {
        this.venue = venue;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Double getLast() {
        return last;
    }

    public void setLast(Double last) {
        this.last = last;
    }

    public Double getChange() {
        return change;
    }

    public void setChange(Double change) {
        this.change = change;
    }

    public Integer getVolume() {
        return volume;
    }

    public void setVolume(Integer volume) {
        this.volume = volume;
    }

    public Double getHigh() {
        return high;
    }

    public void setHigh(Double high) {
        this.high = high;
    }

    public Double getLow() {
        return low;
    }

    public void setLow(Double low) {
        this.low = low;
    }

    public Double getClose() {
        return close;
    }

    public void setClose(Double close) {
        this.close = close;
    }

    public Double getMarketCap() {
        return marketCap;
    }

    public void setMarketCap(Double marketCap) {
        this.marketCap = marketCap;
    }

	public String toString() {
		   return ReflectionToStringBuilder.toString(this);
	}
}
