/*
 * Decompiled with CFR 0.152.
 */
package ch.imvs.sdes4j.srtp;

import ch.imvs.sdes4j.srtp.SrtpSessionParam;

public class KdrSessionParam
extends SrtpSessionParam {
    private final int kdr;

    public KdrSessionParam(int kdr) {
        if (kdr < 0 || kdr > 24) {
            throw new IllegalArgumentException("kdr must be in range 0..24 inclusive");
        }
        this.kdr = kdr;
    }

    public KdrSessionParam(String param) {
        this.kdr = Integer.parseInt(param.substring("KDR=".length()));
        if (this.kdr < 0 || this.kdr > 24) {
            throw new IllegalArgumentException("kdr must be in range 0..24 inclusive");
        }
    }

    public int getKeyDerivationRate() {
        return this.kdr;
    }

    public int getKeyDerivationRateExpanded() {
        return (int)Math.pow(2.0, this.kdr);
    }

    @Override
    public String encode() {
        return "KDR=" + this.kdr;
    }
}

