/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper;

import ch.jalu.configme.beanmapper.BeanDescriptionFactory;
import ch.jalu.configme.beanmapper.BeanPropertyDescription;
import ch.jalu.configme.beanmapper.ConfigMeMapperException;
import ch.jalu.configme.beanmapper.MapperUtils;
import ch.jalu.configme.beanmapper.MappingContext;
import ch.jalu.configme.beanmapper.MappingErrorHandler;
import ch.jalu.configme.beanmapper.transformer.Transformer;
import ch.jalu.configme.beanmapper.transformer.Transformers;
import ch.jalu.configme.resource.PropertyResource;
import ch.jalu.configme.utils.TypeInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class Mapper {
    private final MappingErrorHandler errorHandler;
    private final Transformer[] transformers;
    private final BeanDescriptionFactory beanDescriptionFactory;
    private final Map<String, Collection<BeanPropertyDescription>> classProperties = new HashMap<String, Collection<BeanPropertyDescription>>();

    public Mapper() {
        this(MappingErrorHandler.Impl.SILENT, new BeanDescriptionFactory(), Transformers.getDefaultTransformers());
    }

    public Mapper(MappingErrorHandler mappingErrorHandler, BeanDescriptionFactory beanDescriptionFactory, Transformer ... transformers) {
        this.errorHandler = mappingErrorHandler;
        this.beanDescriptionFactory = beanDescriptionFactory;
        this.transformers = transformers;
    }

    @Nullable
    public <T> T convertToBean(String path, PropertyResource resource, Class<T> clazz) {
        return (T)this.getPropertyValue(TypeInformation.of(clazz), resource.getObject(path), MappingContext.root());
    }

    @Nullable
    protected Object getPropertyValue(TypeInformation typeInformation, @Nullable Object value, MappingContext context) {
        if (typeInformation.getClazz() == Optional.class) {
            TypeInformation<?> typeInOptional = typeInformation.buildGenericType(0);
            return Optional.ofNullable(this.getPropertyValue(typeInOptional, value, context));
        }
        Object result = this.processCollection(typeInformation, value, context);
        if (result != null) {
            return result;
        }
        result = this.processMap(typeInformation, value, context);
        if (result != null) {
            return result;
        }
        result = this.processTransformers(typeInformation, value);
        if (result != null) {
            return result;
        }
        return this.convertToBean(typeInformation, value, context);
    }

    @Nullable
    protected Collection<?> processCollection(TypeInformation<?> type, Object value, MappingContext context) {
        if (type.isOfType(Iterable.class) && value instanceof Iterable) {
            TypeInformation<?> collectionType = type.buildGenericType(0);
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (Iterable)value) {
                Object mappedValue = this.getPropertyValue(collectionType, o, context.createChild(type));
                if (mappedValue == null) continue;
                list.add(mappedValue);
            }
            if (type.isOfType(List.class)) {
                return list;
            }
            if (type.isOfType(Set.class)) {
                return new LinkedHashSet(list);
            }
            throw new ConfigMeMapperException("Unsupported collection type '" + type + "' encountered. Only List and Set are supported by default");
        }
        return null;
    }

    @Nullable
    protected Map processMap(TypeInformation<?> type, Object value, MappingContext context) {
        if (type.isOfType(Map.class) && value instanceof Map) {
            Map entries = (Map)value;
            if (type.getGenericClass(0) != String.class) {
                throw new ConfigMeMapperException("The key type of maps may only be of String type");
            }
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : entries.entrySet()) {
                Object mappedValue = this.getPropertyValue(type.buildGenericType(1), entry.getValue(), context.createChild(type));
                if (mappedValue == null) continue;
                result.put(entry.getKey(), mappedValue);
            }
            return result;
        }
        return null;
    }

    @Nullable
    protected Object processTransformers(TypeInformation typeInformation, Object value) {
        for (Transformer transformer : this.transformers) {
            Object result = transformer.transform(typeInformation, value);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    protected <T> T convertToBean(TypeInformation<T> type, Object value, MappingContext context) {
        Collection<BeanPropertyDescription> properties = this.getWritableProperties(type.getClazz());
        if (properties.isEmpty() || !(value instanceof Map)) {
            return null;
        }
        Map entries = (Map)value;
        T bean = MapperUtils.invokeDefaultConstructor(type.getClazz());
        for (BeanPropertyDescription property : properties) {
            Object result = this.getPropertyValue(property.getTypeInformation(), entries.get(property.getName()), context.createChild(type));
            if (result != null) {
                property.setValue(bean, result);
                continue;
            }
            if (property.getValue(bean) != null) continue;
            this.errorHandler.handleError(property.getClass(), context);
            return null;
        }
        return bean;
    }

    public Collection<BeanPropertyDescription> getWritableProperties(Class<?> clazz) {
        return this.classProperties.computeIfAbsent(clazz.getCanonicalName(), s -> this.beanDescriptionFactory.collectWritableFields(clazz));
    }
}

