/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.configurationdata;

import ch.jalu.configme.Comment;
import ch.jalu.configme.SectionComments;
import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.configurationdata.PropertyListBuilder;
import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ConfigurationDataBuilder {
    private final PropertyListBuilder propertyListBuilder = new PropertyListBuilder();
    private final CommentsGatherer commentsGatherer = new CommentsGatherer();

    private ConfigurationDataBuilder() {
    }

    @SafeVarargs
    public static ConfigurationData collectData(Class<? extends SettingsHolder> ... classes) {
        return ConfigurationDataBuilder.collectData(Arrays.asList(classes));
    }

    public static ConfigurationData collectData(Iterable<Class<? extends SettingsHolder>> classes) {
        ConfigurationDataBuilder builder = new ConfigurationDataBuilder();
        for (Class<? extends SettingsHolder> clazz : classes) {
            builder.collectProperties(clazz);
            builder.commentsGatherer.collectAllSectionComments(clazz);
        }
        return new ConfigurationData(builder.propertyListBuilder.create(), builder.commentsGatherer.getComments());
    }

    private void collectProperties(Class<?> clazz) {
        Field[] declaredFields;
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            Property<?> property = ConfigurationDataBuilder.getPropertyField(field);
            if (property == null) continue;
            this.propertyListBuilder.add(property);
            this.saveComment(field, property.getPath());
        }
    }

    private void saveComment(Field field, String path) {
        if (field.isAnnotationPresent(Comment.class)) {
            this.commentsGatherer.comments.put(path, field.getAnnotation(Comment.class).value());
        }
    }

    @Nullable
    private static Property<?> getPropertyField(Field field) {
        if (Property.class.isAssignableFrom(field.getType()) && Modifier.isStatic(field.getModifiers())) {
            try {
                return (Property)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new ConfigMeException("Could not fetch field '" + field.getName() + "' from class '" + field.getDeclaringClass().getSimpleName() + "'. Is it maybe not public?", e);
            }
        }
        return null;
    }

    private static final class CommentsGatherer {
        private final Map<String, String[]> comments = new HashMap<String, String[]>();

        private CommentsGatherer() {
        }

        void collectAllSectionComments(Class<?> clazz) {
            Arrays.stream(clazz.getMethods()).filter(method -> method.isAnnotationPresent(SectionComments.class)).map(method -> CommentsGatherer.callSectionCommentsMethod(method)).filter(map -> map != null).forEach(this.comments::putAll);
        }

        Map<String, String[]> getComments() {
            return this.comments;
        }

        private static Map<String, String[]> callSectionCommentsMethod(Method method) {
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new ConfigMeException("Methods with @SectionComments must be static. Offending method: '" + method + "'");
            }
            if (method.getParameters().length > 0) {
                throw new ConfigMeException("@SectionComments methods may not have any parameters. Offending method: '" + method + "'");
            }
            try {
                return (Map)method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ConfigMeException("Could not get section comments from '" + method + "'", e);
            }
            catch (ClassCastException e) {
                throw new ConfigMeException("Could not get section comments from '" + method + "': Return value must be Map<String, String[]>", e);
            }
        }
    }
}

