/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.resource.PropertyResource;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class Property<T> {
    private final String path;
    private final T defaultValue;

    protected Property(String path, T defaultValue) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(defaultValue);
        this.path = path;
        this.defaultValue = defaultValue;
    }

    public T getValue(PropertyResource resource) {
        T value = this.getFromResource(resource);
        return value == null ? this.defaultValue : value;
    }

    @Nullable
    protected abstract T getFromResource(PropertyResource var1);

    public boolean isPresent(PropertyResource resource) {
        return this.getFromResource(resource) != null;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "Property '" + this.path + "'";
    }
}

