/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.Property;
import ch.jalu.configme.resource.PropertyResource;
import java.util.Arrays;
import java.util.List;

public class StringListProperty
extends Property<List<String>> {
    public StringListProperty(String path, String ... defaultValues) {
        super(path, Arrays.asList(defaultValues));
    }

    @Override
    protected List<String> getFromResource(PropertyResource resource) {
        List<String> rawList = resource.getList(this.getPath());
        if (rawList != null) {
            for (Object obj : rawList) {
                if (obj instanceof String) continue;
                return null;
            }
            return rawList;
        }
        return null;
    }

    @Override
    public boolean isPresent(PropertyResource resource) {
        return resource.getList(this.getPath()) != null;
    }
}

