/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.resource;

import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PropertyPathTraverser {
    private final ConfigurationData configurationData;
    private List<String> parentPathElements = new ArrayList<String>(0);
    private boolean isFirstProperty = true;

    public PropertyPathTraverser(ConfigurationData configurationData) {
        this.configurationData = configurationData;
    }

    public List<PathElement> getPathElements(Property<?> property) {
        List<String> propertyPath = Arrays.asList(property.getPath().split("\\."));
        List<String> commonPathParts = CollectionUtils.filterCommonStart(this.parentPathElements, propertyPath.subList(0, propertyPath.size() - 1));
        List<String> newPathParts = CollectionUtils.getRange(propertyPath, commonPathParts.size());
        this.parentPathElements = propertyPath.subList(0, propertyPath.size() - 1);
        int indentationLevel = commonPathParts.size();
        String prefix = commonPathParts.isEmpty() ? "" : String.join((CharSequence)".", commonPathParts) + ".";
        return this.convertToPathElements(indentationLevel, prefix, newPathParts);
    }

    private List<PathElement> convertToPathElements(int indentation, String prefix, List<String> elements) {
        ArrayList<PathElement> pathElements = new ArrayList<PathElement>(elements.size());
        for (String element : elements) {
            String[] comments = this.isFirstProperty ? this.getCommentsIncludingRoot(prefix + element) : this.configurationData.getCommentsForSection(prefix + element);
            pathElements.add(new PathElement(indentation, element, comments));
            prefix = prefix + element + ".";
            ++indentation;
        }
        return pathElements;
    }

    private String[] getCommentsIncludingRoot(String path) {
        this.isFirstProperty = false;
        String[] rootComments = this.configurationData.getCommentsForSection("");
        String[] sectionComments = this.configurationData.getCommentsForSection(path);
        return PropertyPathTraverser.mergeArrays(rootComments, sectionComments);
    }

    private static String[] mergeArrays(String[] a, String[] b) {
        int aLen = a.length;
        int bLen = b.length;
        String[] c = new String[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static final class PathElement {
        public final int indentationLevel;
        public final String name;
        public final String[] comments;

        public PathElement(int indentationLevel, String name, String[] comments) {
            this.indentationLevel = indentationLevel;
            this.name = name;
            this.comments = comments;
        }
    }
}

