/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.resource;

import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.resource.PropertyReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.yaml.snakeyaml.Yaml;

public class YamlFileReader
implements PropertyReader {
    private final File file;
    private Map<String, Object> root;
    private boolean hasObjectAsRoot = false;

    public YamlFileReader(File file) {
        this.file = file;
        this.reload();
    }

    @Override
    public Object getObject(String path) {
        String[] keys;
        if (path.isEmpty()) {
            return this.hasObjectAsRoot ? this.root.get("") : this.root;
        }
        Object node = this.root;
        for (String key : keys = path.split("\\.")) {
            if ((node = YamlFileReader.getIfIsMap(key, node)) != null) continue;
            return null;
        }
        return node;
    }

    @Override
    public <T> T getTypedObject(String path, Class<T> clazz) {
        Object value = this.getObject(path);
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }

    @Override
    public void set(String path, Object value) {
        Objects.requireNonNull(path);
        if (path.isEmpty()) {
            this.root.clear();
            this.root.put("", value);
            this.hasObjectAsRoot = true;
        } else {
            if (this.hasObjectAsRoot) {
                throw new ConfigMeException("The root path is a bean property; you cannot set values to any subpath. Modify the bean at the root or set a new one instead.");
            }
            this.setValueInChildPath(path, value);
        }
    }

    private void setValueInChildPath(String path, Object value) {
        HashMap<String, Object> node = this.root;
        String[] keys = path.split("\\.");
        for (int i = 0; i < keys.length - 1; ++i) {
            Object child = node.get(keys[i]);
            if (child instanceof Map) {
                node = (HashMap<String, Object>)child;
                continue;
            }
            HashMap<String, Object> newEntry = new HashMap<String, Object>();
            node.put(keys[i], newEntry);
            if (value == null) {
                return;
            }
            node = newEntry;
        }
        if (value == null) {
            node.remove(keys[keys.length - 1]);
        } else {
            node.put(keys[keys.length - 1], value);
        }
    }

    @Override
    public void reload() {
        try (FileInputStream fis = new FileInputStream(this.file);){
            Object obj = new Yaml().load((InputStream)fis);
            this.root = obj == null ? new HashMap() : (Map)obj;
        }
        catch (IOException e) {
            throw new ConfigMeException("Could not read file '" + this.file + "'", e);
        }
        catch (ClassCastException e) {
            throw new ConfigMeException("Top-level is not a map in '" + this.file + "'", e);
        }
    }

    private static Object getIfIsMap(String key, Object value) {
        if (value instanceof Map) {
            return ((Map)value).get(key);
        }
        return null;
    }
}

