/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.rules;

import ch.maxant.rules.CompileException;
import ch.maxant.rules.DuplicateNameException;
import ch.maxant.rules.IAction;
import ch.maxant.rules.NoActionFoundException;
import ch.maxant.rules.NoMatchingRuleFoundException;
import ch.maxant.rules.ParseException;
import ch.maxant.rules.Rule;
import ch.maxant.rules.SubRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.mvel2.MVEL;

public class Engine {
    public static final String DEFAULT_INPUT_NAME = "input";
    private static final Logger log = Logger.getLogger(Engine.class.getName());
    private List<CompiledRule> rules;
    protected final Set<String> uniqueOutcomes = new HashSet<String>();
    protected List<Rule> parsedRules;
    protected final boolean throwExceptionIfCompilationFails;
    protected final String inputName;
    protected final String[] javascriptFilesToLoad;
    protected final Integer poolSize;

    public Engine(Collection<Rule> rules, boolean throwExceptionIfCompilationFails) throws DuplicateNameException, CompileException, ParseException {
        this(rules, DEFAULT_INPUT_NAME, throwExceptionIfCompilationFails);
    }

    public Engine(Collection<Rule> rules, String inputName, boolean throwExceptionIfCompilationFails) throws DuplicateNameException, CompileException, ParseException {
        this(rules, inputName, throwExceptionIfCompilationFails, null, null);
    }

    protected Engine(Collection<Rule> rules, String inputName, boolean throwExceptionIfCompilationFails, Integer poolSize, String[] javascriptFilesToLoad) throws DuplicateNameException, CompileException, ParseException {
        this.inputName = inputName;
        this.throwExceptionIfCompilationFails = throwExceptionIfCompilationFails;
        this.javascriptFilesToLoad = javascriptFilesToLoad;
        this.poolSize = poolSize;
        this.init(rules);
    }

    protected void init(Collection<Rule> rules) throws DuplicateNameException, CompileException, ParseException {
        log.info("\r\n\r\n*****Initialising rule engine...*****");
        this.rules = new ArrayList<CompiledRule>();
        long start = System.currentTimeMillis();
        HashMap<String, Rule> names = new HashMap<String, Rule>();
        for (Rule r : rules) {
            String fullyQualifiedName = r.getFullyQualifiedName();
            if (names.containsKey(fullyQualifiedName)) {
                throw new DuplicateNameException("The name " + fullyQualifiedName + " was found in a different rule.");
            }
            names.put(r.getFullyQualifiedName(), r);
            this.uniqueOutcomes.add(r.getOutcome());
        }
        this.parsedRules = new ArrayList<Rule>();
        while (true) {
            boolean foundRuleReference = false;
            for (Rule r : rules) {
                int idx1 = r.getExpression().indexOf(35);
                if (idx1 > -1) {
                    char c;
                    foundRuleReference = true;
                    int idx2 = idx1 + 1;
                    while (++idx2 < r.getExpression().length() && (c = r.getExpression().charAt(idx2)) != ' ' && c != '&' && c != '|' && c != '.' && c != '(' && c != ')' && c != '[' && c != ']' && c != '{' && c != '}' && c != '+' && c != '-' && c != '/' && c != '*' && c != '=' && c != '!') {
                    }
                    String token = r.getExpression().substring(idx1 + 1, idx2);
                    String fullyQualifiedRuleRef = r.getNamespace() + "." + token;
                    Rule toAdd = (Rule)names.get(fullyQualifiedRuleRef);
                    if (toAdd == null) {
                        throw new ParseException("Error while attempting to add subrule to rule " + r.getFullyQualifiedName() + ".  Unable to replace #" + token + " with subrule " + fullyQualifiedRuleRef + " because no subrule with that fully qualified name was found");
                    }
                    String newExpression = "";
                    if (idx1 > 0) {
                        newExpression = newExpression + r.getExpression().substring(0, idx1);
                    }
                    newExpression = newExpression + "(" + toAdd.getExpression() + ")";
                    if (idx2 < r.getExpression().length()) {
                        newExpression = newExpression + r.getExpression().substring(idx2, r.getExpression().length());
                    }
                    if (r instanceof SubRule) {
                        this.parsedRules.add(new SubRule(r.getName(), newExpression, r.getNamespace(), r.getDescription()));
                        continue;
                    }
                    this.parsedRules.add(new Rule(r.getName(), newExpression, r.getOutcome(), r.getPriority(), r.getNamespace(), r.getDescription()));
                    continue;
                }
                this.parsedRules.add(r);
            }
            if (!foundRuleReference) break;
            rules = this.parsedRules;
            this.parsedRules = new ArrayList<Rule>();
        }
        this.compile();
        log.info("*****Engine initialisation completed in " + (System.currentTimeMillis() - start) + " ms*****\r\n");
    }

    protected void compile() throws CompileException {
        for (Rule r : this.parsedRules) {
            if (r instanceof SubRule) continue;
            this.addCompiledRule(this.throwExceptionIfCompilationFails, r);
        }
    }

    private void addCompiledRule(boolean throwExceptionIfCompilationFails, Rule r) throws CompileException {
        block2: {
            try {
                this.rules.add(new CompiledRule(r));
                log.info("added rule: " + r);
            }
            catch (org.mvel2.CompileException ex) {
                log.warning("Failed to compile " + r.getFullyQualifiedName() + ": " + ex.getMessage());
                if (!throwExceptionIfCompilationFails) break block2;
                throw new CompileException(ex.getMessage());
            }
        }
    }

    public <Input> String getBestOutcome(Input input) throws NoMatchingRuleFoundException {
        return this.getBestOutcome(null, input);
    }

    public <Input> String getBestOutcome(String nameSpacePattern, Input input) throws NoMatchingRuleFoundException {
        List<Rule> matches = this.getMatchingRules(nameSpacePattern, input);
        if (matches == null || matches.isEmpty()) {
            throw new NoMatchingRuleFoundException();
        }
        return matches.get(0).getOutcome();
    }

    public <Input, Output> Output executeBestAction(Input input, Collection<? extends IAction<Input, Output>> actions) throws NoMatchingRuleFoundException, NoActionFoundException, DuplicateNameException {
        return this.executeBestAction(null, input, actions);
    }

    public <Input, Output> Output executeBestAction(String nameSpacePattern, Input input, Collection<? extends IAction<Input, Output>> actions) throws NoMatchingRuleFoundException, NoActionFoundException, DuplicateNameException {
        Map<String, IAction<Input, Output>> actionsMap = this.validateActions(actions);
        return actionsMap.get(this.getBestOutcome(nameSpacePattern, input)).execute(input);
    }

    public <Input, Output> void executeAllActions(Input input, Collection<? extends IAction<Input, Output>> actions) throws NoMatchingRuleFoundException, NoActionFoundException, DuplicateNameException {
        this.executeAllActions(null, input, actions);
    }

    public <Input, Output> void executeAllActions(String nameSpacePattern, Input input, Collection<? extends IAction<Input, Output>> actions) throws NoMatchingRuleFoundException, NoActionFoundException, DuplicateNameException {
        Map<String, IAction<Input, Output>> actionsMap = this.validateActions(actions);
        List<Rule> matchingRules = this.getMatchingRules(nameSpacePattern, input);
        HashSet<String> executedOutcomes = new HashSet<String>();
        for (Rule r : matchingRules) {
            if (executedOutcomes.contains(r.getOutcome())) continue;
            actionsMap.get(r.getOutcome()).execute(input);
            executedOutcomes.add(r.getOutcome());
        }
    }

    private <Input, Output> Map<String, IAction<Input, Output>> validateActions(Collection<? extends IAction<Input, Output>> actions) throws DuplicateNameException, NoActionFoundException {
        HashMap<String, IAction<Input, Output>> actionsMap = new HashMap<String, IAction<Input, Output>>();
        for (IAction<Input, Output> a : actions) {
            if (actionsMap.containsKey(a.getName())) {
                throw new DuplicateNameException("The name " + a.getName() + " was found in a different action.  Action names must be unique.");
            }
            actionsMap.put(a.getName(), a);
        }
        for (String outcome : this.uniqueOutcomes) {
            if (outcome == null || actionsMap.containsKey(outcome)) continue;
            throw new NoActionFoundException("No action has been associated with the outcome \"" + outcome + "\"");
        }
        return actionsMap;
    }

    public <Input> List<Rule> getMatchingRules(Input input) {
        return this.getMatchingRules(null, input);
    }

    public <Input> List<Rule> getMatchingRules(String nameSpacePattern, Input input) {
        Pattern pattern = null;
        if (nameSpacePattern != null) {
            pattern = Pattern.compile(nameSpacePattern);
        }
        HashMap<String, Input> vars = new HashMap<String, Input>();
        vars.put(this.inputName, input);
        ArrayList<Rule> matchingRules = new ArrayList<Rule>();
        for (CompiledRule r : this.rules) {
            if (pattern != null && !pattern.matcher(r.getRule().getNamespace()).matches()) continue;
            Object o = MVEL.executeExpression((Object)r.getCompiled(), vars);
            String msg = r.getRule().getFullyQualifiedName() + "-{" + r.getRule().getExpression() + "}";
            if (String.valueOf(o).equals("true")) {
                matchingRules.add(r.getRule());
                if (!log.isLoggable(Level.INFO)) continue;
                log.info("matched: " + msg);
                continue;
            }
            if (!log.isLoggable(Level.INFO)) continue;
            log.info("unmatched: " + msg);
        }
        Collections.sort(matchingRules);
        return matchingRules;
    }

    private static final class CompiledRule {
        private Rule rule;
        private Serializable compiled;

        private CompiledRule(Rule rule) {
            this.rule = rule;
            this.compiled = MVEL.compileExpression((String)rule.getExpression());
        }

        private Serializable getCompiled() {
            return this.compiled;
        }

        private Rule getRule() {
            return this.rule;
        }
    }
}

