/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.rules;

import ch.maxant.rules.CompileException;
import ch.maxant.rules.DuplicateNameException;
import ch.maxant.rules.ParseException;
import ch.maxant.rules.Rule;
import ch.maxant.rules.SubRule;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class JavascriptEngine
extends ch.maxant.rules.Engine {
    private static final Logger log = Logger.getLogger(JavascriptEngine.class.getName());
    private static final String MIME_TYPE = "text/javascript";
    private static final ScriptEngineManager ENGINE_MANAGER = new ScriptEngineManager();
    private ObjectPool<Engine> engines;

    public int[] getPoolSize() {
        return new int[]{this.engines.getNumActive(), this.engines.getNumIdle()};
    }

    public JavascriptEngine(Collection<Rule> rules, boolean throwExceptionIfCompilationFails, String ... javascriptFilesToLoad) throws DuplicateNameException, CompileException, ParseException {
        this(rules, "input", throwExceptionIfCompilationFails, null, false, javascriptFilesToLoad);
    }

    public JavascriptEngine(Collection<Rule> rules, String inputName, boolean throwExceptionIfCompilationFails, Integer poolSize, boolean preloadPool, String ... javascriptFilesToLoad) throws DuplicateNameException, CompileException, ParseException {
        super(rules, inputName, throwExceptionIfCompilationFails, poolSize, javascriptFilesToLoad);
        if (preloadPool) {
            try {
                ArrayList<Object> borrowed = new ArrayList<Object>();
                for (int i = 0; i < (poolSize == null ? 8 : poolSize); ++i) {
                    borrowed.add(this.engines.borrowObject());
                }
                for (Engine engine : borrowed) {
                    this.engines.returnObject((Object)engine);
                }
            }
            catch (Exception e) {
                this.handlePoolProblem(e);
            }
        }
    }

    protected GenericObjectPoolConfig getPoolConfig() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        if (this.poolSize != null) {
            config.setMaxTotal(this.poolSize.intValue());
        }
        return config;
    }

    private void preloadOtherScripts(Engine engine) throws CompileException {
        if (this.javascriptFilesToLoad != null) {
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream script = null;
            for (String js : this.javascriptFilesToLoad) {
                boolean assumedItsAScriptNotAFile = false;
                try {
                    script = cl.getResourceAsStream(js);
                    if (script == null) {
                        log.info("Assuming that the given string is an actual script, rather than the name of a file containing one: '" + js + "'");
                        assumedItsAScriptNotAFile = true;
                        engine.engine.eval(js);
                        continue;
                    }
                    log.info("Found script named '" + js + "' on classpath - attempting to evaluate it...");
                    engine.engine.eval(new InputStreamReader(script));
                }
                catch (ScriptException e) {
                    if (assumedItsAScriptNotAFile) {
                        throw new CompileException("No file named '" + js + "' found on classpath. Assumed a script was passed instead.  But failed to evaluate script: " + e.getMessage());
                    }
                    throw new CompileException("Failed to evaluate script named '" + js + "': " + e.getMessage());
                }
                finally {
                    if (script != null) {
                        try {
                            script.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
    }

    private void returnEngineToPool(Engine engine) {
        if (engine != null) {
            try {
                this.engines.returnObject((Object)engine);
            }
            catch (Exception e) {
                this.handlePoolProblem(e);
            }
        }
    }

    private void handlePoolProblem(Exception e) {
        throw new RuntimeException("problem with engine pool", e);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void compile() throws CompileException {
        Engine engine = null;
        try {
            if (this.engines == null) {
                this.engines = new GenericObjectPool((PooledObjectFactory)new PoolableEngineFactory(), this.getPoolConfig());
            }
            engine = (Engine)this.engines.borrowObject();
            this.returnEngineToPool(engine);
            return;
        }
        catch (CompileException e) {
            try {
                throw e;
                catch (Exception e2) {
                    this.handlePoolProblem(e2);
                    this.returnEngineToPool(engine);
                    return;
                }
            }
            catch (Throwable throwable) {
                this.returnEngineToPool(engine);
                throw throwable;
            }
        }
    }

    private void compile(Engine engine) throws CompileException {
        for (Rule r : this.parsedRules) {
            try {
                if (r instanceof SubRule) continue;
                CompiledScript compiledScript = ((Compilable)((Object)engine.engine)).compile(r.getExpression());
                engine.rules.put(r, compiledScript);
            }
            catch (ScriptException ex) {
                log.warning("Failed to compile " + r.getFullyQualifiedName() + ": " + ex.getMessage());
                if (!this.throwExceptionIfCompilationFails) continue;
                throw new CompileException(ex.getMessage());
            }
        }
        this.preloadOtherScripts(engine);
    }

    @Override
    public <Input> List<Rule> getMatchingRules(String nameSpacePattern, Input input) {
        Pattern pattern = null;
        if (nameSpacePattern != null) {
            pattern = Pattern.compile(nameSpacePattern);
        }
        Engine engine = null;
        Rule r = null;
        try {
            try {
                engine = (Engine)this.engines.borrowObject();
            }
            catch (Exception e) {
                this.handlePoolProblem(e);
            }
            ArrayList<Rule> matchingRules = new ArrayList<Rule>();
            for (Map.Entry e : engine.rules.entrySet()) {
                r = (Rule)e.getKey();
                if (pattern != null && !pattern.matcher(((Rule)e.getKey()).getNamespace()).matches()) continue;
                engine.engine.getContext().setAttribute(this.inputName, input, 100);
                Object result = ((CompiledScript)e.getValue()).eval();
                String msg = r.getFullyQualifiedName() + "-{" + r.getExpression() + "}";
                if (String.valueOf(result).equals("true")) {
                    matchingRules.add(r);
                    if (!log.isLoggable(Level.INFO)) continue;
                    log.info("matched: " + msg);
                    continue;
                }
                if (!log.isLoggable(Level.INFO)) continue;
                log.info("unmatched: " + msg);
            }
            Collections.sort(matchingRules);
            ArrayList<Rule> arrayList = matchingRules;
            this.returnEngineToPool(engine);
            return arrayList;
        }
        catch (ScriptException e) {
            try {
                throw new IllegalArgumentException("Failed to run script " + r.getFullyQualifiedName(), e);
            }
            catch (Throwable throwable) {
                this.returnEngineToPool(engine);
                throw throwable;
            }
        }
    }

    static {
        ScriptEngine engine = ENGINE_MANAGER.getEngineByMimeType(MIME_TYPE);
        ScriptEngineFactory factory = engine.getFactory();
        if (log.isLoggable(Level.INFO)) {
            log.info("Using JavaScript engine " + factory.getEngineName() + "/" + factory.getEngineVersion() + "/" + factory.getLanguageName() + "/" + factory.getLanguageVersion() + "/" + factory.getExtensions() + "/" + factory.getMimeTypes() + "/" + factory.getNames() + "/" + "threading model: " + factory.getParameter("THREADING"));
        }
    }

    public static final class Builder {
        private final Collection<Rule> rules;
        private String inputName = "input";
        private boolean throwExceptionIfCompilationFails = true;
        private Integer poolSize = 8;
        private boolean preloadPool = false;
        private String[] javascriptFilesToLoad = new String[0];

        public Builder(Collection<Rule> rules) {
            this.rules = rules;
        }

        public Builder withInputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public Builder withThrowExceptionIfCompilationFails(boolean throwExceptionIfCompilationFails) {
            this.throwExceptionIfCompilationFails = throwExceptionIfCompilationFails;
            return this;
        }

        public Builder withPoolSize(Integer poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public Builder withPreloadPool(boolean preloadPool) {
            this.preloadPool = preloadPool;
            return this;
        }

        public Builder withJavascriptFilesToLoad(String ... javascriptFilesToLoad) {
            this.javascriptFilesToLoad = javascriptFilesToLoad;
            return this;
        }

        public JavascriptEngine build() throws DuplicateNameException, CompileException, ParseException {
            return new JavascriptEngine(this.rules, this.inputName, this.throwExceptionIfCompilationFails, this.poolSize, this.preloadPool, this.javascriptFilesToLoad);
        }
    }

    private static final class Engine {
        private ScriptEngine engine;
        private Map<Rule, CompiledScript> rules = new HashMap<Rule, CompiledScript>();

        private Engine() {
        }
    }

    private final class PoolableEngineFactory
    extends BasePooledObjectFactory<Engine> {
        private PoolableEngineFactory() {
        }

        public Engine create() throws Exception {
            log.info("\r\n\r\n>>>Creating JavaScript rule engine...<<<");
            long start = System.currentTimeMillis();
            Engine engine = new Engine();
            engine.engine = ENGINE_MANAGER.getEngineByMimeType(JavascriptEngine.MIME_TYPE);
            JavascriptEngine.this.compile(engine);
            log.info(">>>JavaScript rule engine initialisation completed in " + (System.currentTimeMillis() - start) + " ms<<<\r\n");
            return engine;
        }

        public PooledObject<Engine> wrap(Engine obj) {
            return new DefaultPooledObject((Object)obj);
        }
    }
}

