/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.rules;

public class Rule
implements Comparable<Rule> {
    private final String name;
    private final String expression;
    private final String outcome;
    private final int priority;
    private final String namespace;
    private final String description;

    public Rule(String name, String expression, String outcome, int priority, String namespace, String description) {
        if (name == null) {
            throw new AssertionError((Object)"name may not be null");
        }
        if (expression == null) {
            throw new AssertionError((Object)"expression may not be null");
        }
        if (namespace == null) {
            throw new AssertionError((Object)"namespace may not be null");
        }
        this.name = name;
        this.expression = expression;
        this.outcome = outcome;
        this.priority = priority;
        this.namespace = namespace;
        this.description = description;
    }

    public Rule(String name, String expression, String outcome, int priority, String namespace) {
        this(name, expression, outcome, priority, namespace, null);
    }

    @Override
    public int compareTo(Rule r) {
        return this.priority < r.priority ? 1 : (this.priority == r.priority ? 0 : -1);
    }

    public String getFullyQualifiedName() {
        return this.namespace + "." + this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.outcome == null ? 0 : this.outcome.hashCode());
        result = 31 * result + this.priority;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rule other = (Rule)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.outcome == null ? other.outcome != null : !this.outcome.equals(other.outcome)) {
            return false;
        }
        return this.priority == other.priority;
    }

    public String toString() {
        return "Rule [name=" + this.name + ", expression=" + this.expression + ", outcome=" + this.outcome + ", priority=" + this.priority + ", namespace=" + this.namespace + ", description=" + this.description + "]";
    }

    public String getName() {
        return this.name;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDescription() {
        return this.description;
    }
}

