/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.net.SocketNode;
import ch.qos.logback.core.Context;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSocketServer {
    static Logger logger = LoggerFactory.getLogger(SimpleSocketServer.class);
    static int port;

    public static void main(String[] argv) {
        if (argv.length == 2) {
            SimpleSocketServer.init(argv[0], argv[1]);
        } else {
            SimpleSocketServer.usage("Wrong number of arguments.");
        }
        SimpleSocketServer.runServer();
    }

    static void runServer() {
        try {
            logger.info("Listening on port " + port);
            ServerSocket serverSocket = new ServerSocket(port);
            while (true) {
                logger.info("Waiting to accept a new client.");
                Socket socket = serverSocket.accept();
                logger.info("Connected to client at " + socket.getInetAddress());
                logger.info("Starting new socket node.");
                LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
                new Thread(new SocketNode(socket, lc)).start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: java " + SimpleSocketServer.class.getName() + " port configFile");
        System.exit(1);
    }

    static void init(String portStr, String configFile) {
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            SimpleSocketServer.usage("Could not interpret port number [" + portStr + "].");
        }
        if (configFile.endsWith(".xml")) {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            configurator.doConfigure(configFile);
        }
    }
}

