/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import ch.qos.logback.classic.db.DBHelper;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.db.DBAppenderBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBAppender
extends DBAppenderBase {
    protected void subAppend(Object eventObject, Connection connection, PreparedStatement insertStatement) throws Throwable {
        LoggingEvent event = (LoggingEvent)eventObject;
        this.addLoggingEvent(insertStatement, event);
        this.addCallerData(insertStatement, event.getCallerData());
        int updateCount = insertStatement.executeUpdate();
        if (updateCount != 1) {
            this.addWarn("Failed to insert loggingEvent");
        }
        int eventId = this.getEventId(insertStatement, connection);
        Map<String, String> mergedMap = this.mergePropertyMaps(event);
        this.insertProperties(mergedMap, connection, eventId);
        if (event.getThrowableInformation() != null) {
            this.insertThrowable(event.getThrowableInformation().getThrowableStrRep(), connection, eventId);
        }
    }

    void addLoggingEvent(PreparedStatement stmt, LoggingEvent event) throws SQLException {
        stmt.setLong(1, event.getTimeStamp());
        stmt.setString(2, event.getFormattedMessage());
        stmt.setString(3, event.getLoggerRemoteView().getName());
        stmt.setString(4, event.getLevel().toString());
        stmt.setString(5, event.getThreadName());
        stmt.setShort(6, DBHelper.computeReferenceMask(event));
    }

    void addCallerData(PreparedStatement stmt, CallerData[] callerDataArray) throws SQLException {
        CallerData callerData = callerDataArray[0];
        if (callerData != null) {
            stmt.setString(7, callerData.getFileName());
            stmt.setString(8, callerData.getClassName());
            stmt.setString(9, callerData.getMethodName());
            stmt.setString(10, Integer.toString(callerData.getLineNumber()));
        }
    }

    Map<String, String> mergePropertyMaps(LoggingEvent event) {
        HashMap<String, String> mergedMap = new HashMap<String, String>();
        Map<String, String> loggerContextMap = event.getLoggerRemoteView().getLoggerContextView().getPropertyMap();
        Map<String, String> mdcMap = event.getMDCPropertyMap();
        if (loggerContextMap != null) {
            mergedMap.putAll(loggerContextMap);
        }
        if (mdcMap != null) {
            mergedMap.putAll(mdcMap);
        }
        return mergedMap;
    }
}

