/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.SyslogAppenderBase;

public class SyslogAppender
extends SyslogAppenderBase {
    String prefixPattern;
    public static final String DEFAULT_SUFFIX_PATTERN = "[%thread] %logger %m%exception";

    public Layout buildLayout(String facilityStr) {
        PatternLayout pl = new PatternLayout();
        pl.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        if (this.prefixPattern == null) {
            this.prefixPattern = "%syslogStart{" + facilityStr + "}";
        }
        if (this.suffixPattern == null) {
            this.suffixPattern = DEFAULT_SUFFIX_PATTERN;
        }
        pl.setPattern(this.prefixPattern + this.suffixPattern);
        pl.setContext(this.getContext());
        pl.start();
        return pl;
    }

    public int getSeverityForEvent(Object eventObject) {
        LoggingEvent event = (LoggingEvent)eventObject;
        return LevelToSyslogSeverity.convert(event);
    }
}

