/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.MDC;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.LoggerRemoteView;
import ch.qos.logback.classic.spi.ThrowableInformation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Marker;
import org.slf4j.impl.MessageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEvent
implements Serializable {
    private static final long serialVersionUID = 3022264832697160750L;
    private static long startTime = System.currentTimeMillis();
    transient String fqnOfLoggerClass;
    private String threadName;
    private transient Level level;
    private String message;
    private String formattedMessage;
    private Object[] argumentArray;
    private ThrowableInformation throwableInfo;
    private CallerData[] callerDataArray;
    private LoggerRemoteView loggerRemoteView;
    private Marker marker;
    private Map<String, String> mdcPropertyMap;
    private long timeStamp;

    public LoggingEvent() {
    }

    public LoggingEvent(String fqcn, Logger logger, Level level, String message, Throwable throwable, Object[] argArray) {
        this.fqnOfLoggerClass = fqcn;
        this.loggerRemoteView = logger.getLoggerRemoteView();
        this.level = level;
        this.message = message;
        if (throwable != null) {
            this.throwableInfo = new ThrowableInformation(throwable);
        }
        this.formattedMessage = argArray != null ? MessageFormatter.arrayFormat((String)message, (Object[])argArray) : message;
        this.timeStamp = System.currentTimeMillis();
        this.mdcPropertyMap = MDC.getPropertyMap();
    }

    public void setArgumentArray(Object[] argArray) {
        if (this.argumentArray != null) {
            throw new IllegalStateException("argArray has been already set");
        }
        this.argumentArray = argArray;
    }

    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    public void setThreadName(String threadName) throws IllegalStateException {
        if (this.threadName != null) {
            throw new IllegalStateException("threadName has been already set");
        }
        this.threadName = threadName;
    }

    public ThrowableInformation getThrowableInformation() {
        return this.throwableInfo;
    }

    public void setThrowableInformation(ThrowableInformation ti) {
        if (this.throwableInfo != null) {
            throw new IllegalStateException("ThrowableInformation has been already set.");
        }
        this.throwableInfo = ti;
    }

    public void prepareForDeferredProcessing() {
        this.getThreadName();
    }

    public LoggerRemoteView getLoggerRemoteView() {
        return this.loggerRemoteView;
    }

    public void setLoggerRemoteView(LoggerRemoteView loggerRemoteView) {
        this.loggerRemoteView = loggerRemoteView;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        if (this.message != null) {
            throw new IllegalStateException("The message for this event has been set already.");
        }
        this.message = message;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setLevel(Level level) {
        if (this.level != null) {
            throw new IllegalStateException("The level has been already set for this event.");
        }
        this.level = level;
    }

    public static final long getStartTime() {
        return startTime;
    }

    public CallerData[] getCallerData() {
        if (this.callerDataArray == null && this.fqnOfLoggerClass != null) {
            this.callerDataArray = CallerData.extract(new Throwable(), this.fqnOfLoggerClass);
        }
        return this.callerDataArray;
    }

    public void setCallerInformation(CallerData[] callerDataArray) {
        this.callerDataArray = callerDataArray;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        if (this.marker != null) {
            throw new IllegalStateException("The marker has been already set for this event.");
        }
        this.marker = marker;
    }

    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    public Map<String, String> getMDCPropertyMap() {
        return this.mdcPropertyMap;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.level.levelInt);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int levelInt = in.readInt();
        this.level = Level.toLevel(levelInt);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(91);
        sb.append(this.level).append("] ");
        sb.append(this.getFormattedMessage());
        sb.append("\n");
        return sb.toString();
    }
}

