/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.util.StatusListenerConfigHelper;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.Loader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "logback.xml";
    public static final String TEST_AUTOCONFIG_FILE = "logback-test.xml";
    public static final String CONFIG_FILE_PROPERTY = "logback.configurationFile";
    public static final String STATUS_LISTENER_CLASS = "logback.statusListenerClass";
    public static final String SYSOUT = "SYSOUT";
    final LoggerContext loggerContext;

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
    }

    public void configureByResource(URL url) throws JoranException {
        if (url == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)this.loggerContext);
        configurator.doConfigure(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL findConfigFileURLFromSystemProperties() {
        String logbackConfigFile = System.getProperty(CONFIG_FILE_PROPERTY, null);
        if (logbackConfigFile != null) {
            URL result = null;
            try {
                URL uRL = result = new URL(logbackConfigFile);
                return uRL;
            }
            catch (MalformedURLException e) {
                result = Loader.getResourceBySelfClassLoader((String)logbackConfigFile);
                if (result != null) {
                    URL uRL = result;
                    return uRL;
                }
                File f = new File(logbackConfigFile);
                if (f.exists() && f.isFile()) {
                    try {
                        URL uRL = result = f.toURL();
                        return uRL;
                    }
                    catch (MalformedURLException e1) {}
                }
            }
            finally {
                this.statusOnResourceSearch(logbackConfigFile, result);
            }
        }
        return null;
    }

    public void autoConfig() throws JoranException {
        StatusListenerConfigHelper.installIfAsked(this.loggerContext);
        URL url = this.findConfigFileURLFromSystemProperties();
        if (url == null) {
            url = Loader.getResourceBySelfClassLoader((String)TEST_AUTOCONFIG_FILE);
            this.statusOnResourceSearch(TEST_AUTOCONFIG_FILE, url);
        }
        if (url == null) {
            url = Loader.getResourceBySelfClassLoader((String)AUTOCONFIG_FILE);
            this.statusOnResourceSearch(AUTOCONFIG_FILE, url);
        }
        if (url != null) {
            this.configureByResource(url);
        } else {
            BasicConfigurator.configure(this.loggerContext);
        }
    }

    private void statusOnResourceSearch(String resourceName, URL url) {
        StatusManager sm = this.loggerContext.getStatusManager();
        if (url == null) {
            sm.add((Status)new InfoStatus("Could NOT find resource [" + resourceName + "]", (Object)this.loggerContext));
        } else {
            sm.add((Status)new InfoStatus("Found resource [" + resourceName + "]", (Object)this.loggerContext));
        }
    }
}

