/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.helpers.MarkerIgnoringBase;

public class HLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    static int instanceCount = 0;
    private String name;
    private Level level;
    private Level effectiveLevel;
    HLogger parent;
    Map<String, HLogger> childrenMap;
    private ArrayList<Appender<ILoggingEvent>> appenderList;
    protected boolean additive = true;

    HLogger(String name, HLogger parent) {
        this.name = name;
        this.parent = parent;
        ++instanceCount;
    }

    Level getEffectiveLevel() {
        return this.effectiveLevel;
    }

    Level getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    private boolean isRootLogger() {
        return this.parent == null;
    }

    HLogger getChildBySuffix(String suffix) {
        if (this.childrenMap == null) {
            return null;
        }
        return this.childrenMap.get(suffix);
    }

    public synchronized void setLevel(Level newLevel) {
        if (this.level == newLevel) {
            return;
        }
        this.level = newLevel;
        this.effectiveLevel = newLevel;
        if (this.childrenMap != null) {
            for (HLogger child : this.childrenMap.values()) {
                child.handleParentLevelChange(this.effectiveLevel);
            }
        }
    }

    private synchronized void handleParentLevelChange(Level newParentLevel) {
        if (this.level == null) {
            this.effectiveLevel = newParentLevel;
            if (this.childrenMap != null) {
                for (HLogger child : this.childrenMap.values()) {
                    child.handleParentLevelChange(this.effectiveLevel);
                }
            }
        }
    }

    public synchronized void removeAllAppenders() {
        if (this.appenderList != null) {
            int len = this.appenderList.size();
            int i = 0;
            while (i < len) {
                Appender<ILoggingEvent> a = this.appenderList.get(i);
                a.stop();
                ++i;
            }
            this.appenderList.clear();
            this.appenderList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callAppenders(ILoggingEvent event) {
        HLogger l = this;
        while (l != null) {
            HLogger hLogger = l;
            synchronized (hLogger) {
                if (l.appenderList != null) {
                    l.appendLoopOnAppenders(event);
                }
                if (!l.additive) {
                    break;
                }
            }
            l = l.parent;
        }
    }

    private int appendLoopOnAppenders(ILoggingEvent event) {
        int size = 0;
        if (this.appenderList != null) {
            size = this.appenderList.size();
            int i = 0;
            while (i < size) {
                Appender<ILoggingEvent> appender = this.appenderList.get(i);
                appender.doAppend((Object)event);
                ++i;
            }
        }
        return size;
    }

    public synchronized void removeAppender(Appender<ILoggingEvent> appender) {
        if (appender != null) {
            // empty if block
        }
        this.appenderList.remove(appender);
    }

    HLogger createChildByLastNamePart(String lastPart) {
        int i_index = lastPart.indexOf(46);
        if (i_index != -1) {
            throw new IllegalArgumentException("Child name [" + lastPart + " passed as parameter, may not include [" + '.' + "]");
        }
        if (this.childrenMap == null) {
            this.childrenMap = new HashMap<String, HLogger>(2);
        }
        HLogger childHLogger = this.isRootLogger() ? new HLogger(lastPart, this) : new HLogger(String.valueOf(this.name) + '.' + lastPart, this);
        this.childrenMap.put(lastPart, childHLogger);
        childHLogger.effectiveLevel = this.effectiveLevel;
        return childHLogger;
    }

    public final void trace(String msg) {
        if (this.effectiveLevel.levelInt <= 5000) {
            throw new UnsupportedOperationException("not yet implemented");
        }
    }

    public void trace(String msg, Throwable t) {
    }

    public void trace(Object parameterizedMsg, Object param1) {
    }

    public void trace(String parameterizedMsg, Object param1, Object param2) {
    }

    public final void debug(String msg) {
        if (this.effectiveLevel.levelInt <= 10000) {
            throw new UnsupportedOperationException("not yet implemented");
        }
    }

    public void debug(String msg, Throwable t) {
    }

    public void debug(Object parameterizedMsg, Object param1) {
    }

    public void debug(String parameterizedMsg, Object param1, Object param2) {
    }

    public void error(String msg) {
    }

    public void error(String msg, Throwable t) {
    }

    public void error(String parameterizedMsg, Object param1) {
    }

    public void error(String parameterizedMsg, Object param1, Object param2) {
    }

    public void info(String msg) {
    }

    public void info(String msg, Throwable t) {
    }

    public void info(String parameterizedMsg, Object param1) {
    }

    public void info(String parameterizedMsg, Object param1, Object param2) {
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public boolean isErrorEnabled() {
        return false;
    }

    public boolean isInfoEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return false;
    }

    public void warn(String msg) {
    }

    public void warn(String msg, Throwable t) {
    }

    public void warn(String parameterizedMsg, Object param1) {
    }

    public void warn(String parameterizedMsg, Object param1, Object param2) {
    }

    public void trace(String format, Object arg) {
    }

    public void trace(String format, Object[] argArray) {
    }

    public void debug(String format, Object arg) {
    }

    public void debug(String format, Object[] argArray) {
    }

    public void info(String format, Object[] argArray) {
    }

    public void warn(String format, Object[] argArray) {
    }

    public void error(String format, Object[] argArray) {
    }
}

