/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.NOPTurboFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.helpers.NOPAppender;
import ch.qos.logback.core.testUtil.EnvUtilForTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.helpers.BogoPerf;

@Ignore
public class LoggerPerfTest {
    static final long NANOS_IN_ONE_SEC = 1000000000L;
    static long NORMAL_RUN_LENGTH = 1000000L;
    static long SHORTENED_RUN_LENGTH = 500000L;
    LoggerContext lc = new LoggerContext();
    Logger lbLogger = this.lc.getLogger(this.getClass());
    org.slf4j.Logger logger = this.lbLogger;

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void durationOfDisabledLogsWith_1_NOPFilter() {
        double avg = this.computeDurationOfDisabledLogsWith_1_NOPFilter(1, NORMAL_RUN_LENGTH);
        System.out.println("durationOfDisabledLogsWith_1_NOPFilter=" + avg);
        long referencePerf = 60L;
        BogoPerf.assertDuration((double)avg, (long)referencePerf, (double)CoreConstants.REFERENCE_BIPS);
    }

    double computeDurationOfDisabledLogsWith_1_NOPFilter(int numOfFilters, long len) {
        int i = 0;
        while (i < numOfFilters) {
            this.lc.addTurboFilter((TurboFilter)new NOPTurboFilter());
            ++i;
        }
        this.lbLogger.setLevel(Level.OFF);
        long i2 = 0L;
        while (i2 < len) {
            this.logger.debug("Toto");
            ++i2;
        }
        long start = System.nanoTime();
        long i3 = 0L;
        while (i3 < len) {
            this.logger.debug("Toto");
            ++i3;
        }
        return (System.nanoTime() - start) / len;
    }

    @Test
    public void durationOfIsDebugEnabled() {
        double avg = this.computedurationOfIsDebugEnabled(10L * NORMAL_RUN_LENGTH);
        System.out.println("durationOfIsDebugEnabled=" + avg);
        long referencePerf = 15L;
        BogoPerf.assertDuration((double)avg, (long)referencePerf, (double)CoreConstants.REFERENCE_BIPS);
    }

    double computedurationOfIsDebugEnabled(long len) {
        this.lbLogger.setLevel(Level.OFF);
        long i = 0L;
        while (i < len) {
            this.logger.isDebugEnabled();
            ++i;
        }
        Thread.yield();
        i = 0L;
        while (i < len) {
            this.logger.isDebugEnabled();
            ++i;
        }
        long start = System.nanoTime();
        long i2 = 0L;
        while (i2 < len) {
            this.logger.isDebugEnabled();
            ++i2;
        }
        return (System.nanoTime() - start) / len;
    }

    @Test
    public void durationOfDisabledLog_NoParameters() {
        double avg = this.computeDurationOfDisabledLog_NoParameters(10L * NORMAL_RUN_LENGTH);
        System.out.println("durationOfDisabledLog_NoParameters=" + avg);
        long referencePerf = 18L;
        BogoPerf.assertDuration((double)avg, (long)referencePerf, (double)CoreConstants.REFERENCE_BIPS);
    }

    double computeDurationOfDisabledLog_NoParameters(long len) {
        this.lbLogger.setLevel(Level.OFF);
        long i = 0L;
        while (i < len) {
            this.logger.debug("Toto");
            ++i;
        }
        Thread.yield();
        i = 0L;
        while (i < len) {
            this.logger.debug("Toto");
            ++i;
        }
        Thread.yield();
        long start = System.nanoTime();
        long i2 = 0L;
        while (i2 < len) {
            this.logger.debug("Toto");
            ++i2;
        }
        return (System.nanoTime() - start) / len;
    }

    @Test
    public void durationOfDisabledLog_1_Parameter() {
        double avgDuration = this.computeDurationOfDisabledLog_1_Parameter(NORMAL_RUN_LENGTH);
        System.out.println("durationOfDisabledLog_1_Parameter=" + avgDuration);
        long referencePerf = 30L;
        BogoPerf.assertDuration((double)avgDuration, (long)referencePerf, (double)CoreConstants.REFERENCE_BIPS);
    }

    double computeDurationOfDisabledLog_1_Parameter(long len) {
        this.lbLogger.setLevel(Level.OFF);
        Object o = new Object();
        long i = 0L;
        while (i < len) {
            this.logger.debug("Toto {}", o);
            ++i;
        }
        long start = System.nanoTime();
        long i2 = 0L;
        while (i2 < len) {
            this.logger.debug("Toto {}", o);
            ++i2;
        }
        long end = System.nanoTime();
        return (end - start) / len;
    }

    @Test
    public void durationOfEnabledLog() {
        if (EnvUtilForTests.isLinux()) {
            return;
        }
        double avgDuration = this.computeDurationOfEnabledLog(SHORTENED_RUN_LENGTH);
        System.out.println("durationOfEnabledLog=" + avgDuration);
        long referencePerf = 800L;
        BogoPerf.assertDuration((double)avgDuration, (long)referencePerf, (double)CoreConstants.REFERENCE_BIPS);
    }

    double computeDurationOfEnabledLog(long len) {
        this.lbLogger.setLevel(Level.ALL);
        NOPAppender nopAppender = new NOPAppender();
        nopAppender.start();
        ((Logger)this.logger).addAppender((Appender)nopAppender);
        long i = 0L;
        while (i < len) {
            this.logger.debug("Toto");
            ++i;
        }
        long start = System.nanoTime();
        long i2 = 0L;
        while (i2 < len) {
            this.logger.debug("Toto");
            ++i2;
        }
        long end = System.nanoTime();
        return (end - start) / len;
    }

    @Test
    public void testThreadedLogging() throws InterruptedException {
        SleepAppender appender = new SleepAppender();
        int MILLIS_PER_CALL = 250;
        int NANOS_PER_CALL = 250000000;
        appender.setDuration(MILLIS_PER_CALL);
        appender.start();
        this.lbLogger.addAppender(appender);
        this.lbLogger.setLevel(Level.DEBUG);
        int threadCount = 10;
        int iterCount = 5;
        TestRunner[] threads = new TestRunner[threadCount];
        int i = 0;
        while (i < threads.length) {
            threads[i] = new TestRunner(this.logger, iterCount);
            ++i;
        }
        long start = System.nanoTime();
        TestRunner[] testRunnerArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            TestRunner thread = testRunnerArray[n2];
            thread.start();
            ++n2;
        }
        testRunnerArray = threads;
        n = threads.length;
        n2 = 0;
        while (n2 < n) {
            TestRunner thread = testRunnerArray[n2];
            thread.join();
            ++n2;
        }
        long end = System.nanoTime();
        double tolerance = (double)threadCount * 0.125;
        double max = (double)NANOS_PER_CALL / 1.0E9 * (double)iterCount * tolerance;
        double serialized = (double)NANOS_PER_CALL / 1.0E9 * (double)iterCount * (double)threadCount;
        double actual = (double)(end - start) / 1.0E9;
        System.out.printf("Sleep duration: %,.4f seconds. Max expected: %,.4f seconds, Serialized: %,.4f\n", actual, max, serialized);
        Assert.assertTrue((String)"Exceeded maximum expected time.", (actual < max ? 1 : 0) != 0);
    }

    public static class SleepAppender<E>
    extends UnsynchronizedAppenderBase<E> {
        private static long duration = 500L;

        public void setDuration(long millis) {
            duration = millis;
        }

        protected void append(E eventObject) {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static class TestRunner
    extends Thread {
        private org.slf4j.Logger logger;
        private long len;

        public TestRunner(org.slf4j.Logger logger, long len) {
            this.logger = logger;
            this.len = len;
        }

        @Override
        public void run() {
            Thread.yield();
            long i = 0L;
            while (i < this.len) {
                this.logger.debug("Toto");
                ++i;
            }
        }
    }
}

