/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.control;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.control.ControlLogger;
import java.util.HashMap;
import java.util.Map;

public class ControlLoggerContext {
    private ControlLogger root;
    Map<String, ControlLogger> loggerMap = new HashMap<String, ControlLogger>();

    public ControlLoggerContext() {
        this.root = new ControlLogger("root", null);
        this.root.setLevel(Level.DEBUG);
    }

    public ControlLogger getRootLogger() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlLogger exists(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter cannot be null");
        }
        Map<String, ControlLogger> map = this.loggerMap;
        synchronized (map) {
            return this.loggerMap.get(name);
        }
    }

    public final ControlLogger getLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter cannot be null");
        }
        Map<String, ControlLogger> map = this.loggerMap;
        synchronized (map) {
            ControlLogger cl = this.loggerMap.get(name);
            if (cl != null) {
                return cl;
            }
            ControlLogger parent = this.root;
            int i = 0;
            while (true) {
                if ((i = name.indexOf(46, i)) == -1) {
                    cl = new ControlLogger(name, parent);
                    this.loggerMap.put(name, cl);
                    return cl;
                }
                String parentName = name.substring(0, i);
                ControlLogger p = this.loggerMap.get(parentName);
                if (p == null) {
                    p = new ControlLogger(parentName, parent);
                    this.loggerMap.put(parentName, p);
                }
                parent = p;
                ++i;
            }
        }
    }

    public Map<String, ControlLogger> getLoggerMap() {
        return this.loggerMap;
    }
}

