/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.lbclassic36;

import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DateFormatOriginal_tzest
extends TestCase {
    public static final String ISO8601_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    static final long NANOS_IN_ONE_SEC = 1000000000L;

    public DateFormatOriginal_tzest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(DateFormatOriginal_tzest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DateFormatOriginal_tzest.suite());
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSynchronized() throws Exception {
        Thread thread;
        SynchronizedDateFormatter formatter = new SynchronizedDateFormatter();
        int threads = 10;
        int iterations = 10000;
        Thread[] formatThreads = new Thread[threads];
        Date date = new Date();
        int i = 0;
        while (i < threads) {
            formatThreads[i] = new DateFormatThread(formatter, date, iterations);
            ++i;
        }
        long start = System.nanoTime();
        Thread[] threadArray = formatThreads;
        int n = formatThreads.length;
        int n2 = 0;
        while (n2 < n) {
            thread = threadArray[n2];
            thread.start();
            ++n2;
        }
        threadArray = formatThreads;
        n = formatThreads.length;
        n2 = 0;
        while (n2 < n) {
            thread = threadArray[n2];
            thread.join();
            ++n2;
        }
        long end = System.nanoTime();
        double actual = (double)(end - start) / 1.0E9;
        System.out.printf("Synchronized DateFormat: %,.4f seconds\n", actual);
    }

    public void testUnSynchronized() throws Exception {
        Thread thread;
        UnsynchronizedDateFormatter formatter = new UnsynchronizedDateFormatter();
        int threads = 10;
        int iterations = 10000;
        Thread[] formatThreads = new Thread[threads];
        Date date = new Date();
        int i = 0;
        while (i < threads) {
            formatThreads[i] = new DateFormatThread(formatter, date, iterations);
            ++i;
        }
        long start = System.nanoTime();
        Thread[] threadArray = formatThreads;
        int n = formatThreads.length;
        int n2 = 0;
        while (n2 < n) {
            thread = threadArray[n2];
            thread.start();
            ++n2;
        }
        threadArray = formatThreads;
        n = formatThreads.length;
        n2 = 0;
        while (n2 < n) {
            thread = threadArray[n2];
            thread.join();
            ++n2;
        }
        long end = System.nanoTime();
        double actual = (double)(end - start) / 1.0E9;
        System.out.printf("Unsynchronized DateFormat: %,.4f seconds\n", actual);
    }

    public void testThreadLocal() throws Exception {
        Thread thread;
        ThreadLocalDateFormatter formatter = new ThreadLocalDateFormatter();
        int threads = 10;
        int iterations = 10000;
        Thread[] formatThreads = new Thread[threads];
        Date date = new Date();
        int i = 0;
        while (i < threads) {
            formatThreads[i] = new DateFormatThread(formatter, date, iterations);
            ++i;
        }
        long start = System.nanoTime();
        Thread[] threadArray = formatThreads;
        int n = formatThreads.length;
        int n2 = 0;
        while (n2 < n) {
            thread = threadArray[n2];
            thread.start();
            ++n2;
        }
        threadArray = formatThreads;
        n = formatThreads.length;
        n2 = 0;
        while (n2 < n) {
            thread = threadArray[n2];
            thread.join();
            ++n2;
        }
        long end = System.nanoTime();
        double actual = (double)(end - start) / 1.0E9;
        System.out.printf("ThreadLocal DateFormat: %,.4f seconds\n", actual);
    }

    public static class DateFormatThread
    extends Thread {
        Formatter formatter;
        Date date;
        long iterCount;

        public DateFormatThread(Formatter f, Date date, long iterations) {
            this.formatter = f;
            this.date = date;
            this.iterCount = iterations;
        }

        @Override
        public void run() {
            int i = 0;
            while ((long)i < this.iterCount) {
                this.formatter.format(this.date);
                ++i;
            }
        }
    }

    public static interface Formatter {
        public String format(Date var1);
    }

    public static class SynchronizedDateFormatter
    implements Formatter {
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

        @Override
        public synchronized String format(Date date) {
            return this.simpleFormat.format(date);
        }
    }

    public static class ThreadLocalDateFormatter
    implements Formatter {
        ThreadLocal<SimpleDateFormat> formatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected synchronized SimpleDateFormat initialValue() {
                return new SimpleDateFormat(DateFormatOriginal_tzest.ISO8601_PATTERN);
            }
        };

        @Override
        public String format(Date date) {
            return this.formatter.get().format(date);
        }
    }

    public static class UnsynchronizedDateFormatter
    implements Formatter {
        @Override
        public synchronized String format(Date date) {
            return new SimpleDateFormat(DateFormatOriginal_tzest.ISO8601_PATTERN).format(date);
        }
    }
}

