/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.lbclassic36;

import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFormatPerf_Tapp {
    public static final String ISO8601_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    static final long NANOS_IN_ONE_SEC = 1000000000L;
    static long RUN_LENGTH = 1000000L;

    public static void main(String[] args) {
        int i = 0;
        while (i < 5) {
            DateFormatPerf_Tapp.doRawJoda();
            DateFormatPerf_Tapp.doRawSDF();
            ++i;
        }
        DateFormatPerf_Tapp.print("Raw Joda:     ", DateFormatPerf_Tapp.doRawJoda());
        DateFormatPerf_Tapp.print("Raw SDF:      ", DateFormatPerf_Tapp.doRawSDF());
    }

    static void print(String msg, double avg) {
        System.out.println(String.valueOf(msg) + " average tick " + avg + " nanoseconds");
    }

    static double doRawJoda() {
        new Date().getTime();
        long start = System.nanoTime();
        int i = 0;
        while ((long)i < RUN_LENGTH) {
            ++i;
        }
        return (double)(System.nanoTime() - start) * 1.0 / (double)RUN_LENGTH;
    }

    static double doRawSDF() {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(ISO8601_PATTERN);
        long timeInMillis = new Date().getTime();
        long start = System.nanoTime();
        int i = 0;
        while ((long)i < RUN_LENGTH) {
            simpleFormat.format(timeInMillis);
            ++i;
        }
        return (double)(System.nanoTime() - start) * 1.0 / (double)RUN_LENGTH;
    }
}

