/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.lbcore224;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Reduce {
    static int NA = -1;

    public static void main(String[] args) throws IOException {
        File inputFile = new File(args[0]);
        if (!inputFile.exists()) {
            throw new IllegalArgumentException("Missing file [" + args[0] + "]");
        }
        List<String> lines = Reduce.readFile(inputFile);
        System.out.println("Lines count=" + lines.size());
        List<Structure> structuredLines = Reduce.structure(lines);
        List<Structure> reduction = Reduce.reduce(structuredLines);
        if (reduction.isEmpty()) {
            System.out.println("Reduction is EMPTY as it should be.");
        } else {
            System.out.println("Non-empty reduction!!! WTF?");
            System.out.println(reduction);
        }
    }

    private static List<String> readFile(File inputFile) throws IOException {
        BufferedReader reader = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            reader = new BufferedReader(new FileReader(inputFile));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (Throwable throwable) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return lines;
    }

    private static List<Structure> reduce(List<Structure> structuredLines) {
        ArrayList<Structure> matching = new ArrayList<Structure>();
        int lockIndex = 0;
        while (lockIndex < structuredLines.size()) {
            if ((lockIndex = Reduce.findNearestLock(structuredLines, lockIndex)) == NA) break;
            int unlockIndex = Reduce.findNearestUnlockInSameThread(structuredLines, lockIndex);
            if (unlockIndex != NA) {
                matching.add(structuredLines.get(lockIndex));
                matching.add(structuredLines.get(unlockIndex));
            }
            ++lockIndex;
        }
        System.out.println("matching list size: " + matching.size());
        ArrayList<Structure> reduction = new ArrayList<Structure>();
        for (Structure s : structuredLines) {
            if (matching.contains(s)) continue;
            reduction.add(s);
        }
        return reduction;
    }

    private static int findNearestLock(List<Structure> reduction, int index) {
        int i = index;
        while (i < reduction.size()) {
            Structure s = reduction.get(i);
            if (s.operationType == OperationType.LOCK) {
                return i;
            }
            ++i;
        }
        return NA;
    }

    private static int findNearestUnlockInSameThread(List<Structure> reduction, int lockIndex) {
        int firstCandidateIndex = lockIndex + 1;
        Structure lockStructure = reduction.get(lockIndex);
        int i = firstCandidateIndex;
        while (i < reduction.size()) {
            Structure s = reduction.get(i);
            if (s.operationType == OperationType.UNLOCK && lockStructure.thread.equals(s.thread)) {
                return i;
            }
            ++i;
        }
        return NA;
    }

    static List<Structure> structure(List<String> lines) {
        ArrayList<Structure> structuredLines = new ArrayList<Structure>();
        Pattern p = Pattern.compile("(\\d{2,5})\\ +(.*) (LOCK|UNLOCK)");
        for (String line : lines) {
            Matcher m = p.matcher(line);
            if (m.matches()) {
                String relTime = m.group(1);
                String t = m.group(2);
                String opStr = m.group(3);
                Structure structure = Reduce.buildStructure(relTime, t, opStr);
                structuredLines.add(structure);
                continue;
            }
            System.out.println("NON MATCHING LINE: [" + line + "]");
        }
        return structuredLines;
    }

    private static Structure buildStructure(String relTime, String t, String opStr) {
        OperationType operationType;
        long r = Long.parseLong(relTime);
        if (opStr.equals("LOCK")) {
            operationType = OperationType.LOCK;
        } else if (opStr.equals("UNLOCK")) {
            operationType = OperationType.UNLOCK;
        } else {
            throw new IllegalArgumentException(String.valueOf(opStr) + " is not LOCK|UNLOCK");
        }
        return new Structure(r, t, operationType);
    }

    static enum OperationType {
        LOCK,
        UNLOCK;

    }

    static class Structure {
        long time;
        String thread;
        OperationType operationType;

        Structure(long time, String thread, OperationType operationType) {
            this.time = time;
            this.thread = thread;
            this.operationType = operationType;
        }

        public String toString() {
            return "Structure{time=" + this.time + ", thread='" + this.thread + '\'' + ", operationType=" + (Object)((Object)this.operationType) + '}';
        }
    }
}

