/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.lbcore243;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.issue.lbcore243.Common;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceComparatorLogback {
    static Logger logbacklogger = LoggerFactory.getLogger(PerformanceComparatorLogback.class);
    static String DIR_PREFIX = "src/test/java/ch/qos/logback/classic/issue/lbcore243/";

    public static void main(String[] args) throws JoranException, InterruptedException {
        PerformanceComparatorLogback.initLogbackWithoutImmediateFlush();
        PerformanceComparatorLogback.logbackParametrizedDebugCall();
        PerformanceComparatorLogback.initLogbackWithImmediateFlush();
        PerformanceComparatorLogback.logbackParametrizedDebugCall();
        System.out.println("###############################################");
        System.out.println("Logback  with    immediate flush: " + PerformanceComparatorLogback.logbackParametrizedDebugCall() + " nanos per call");
        PerformanceComparatorLogback.initLogbackWithoutImmediateFlush();
        System.out.println("Logback  without immediate flush: " + PerformanceComparatorLogback.logbackParametrizedDebugCall() + " nanos per call");
        System.out.println("###############################################");
    }

    private static long logbackParametrizedDebugCall() {
        Integer j = new Integer(2);
        long start = System.nanoTime();
        int i = 0;
        while (i < Common.loop) {
            logbacklogger.debug("SEE IF THIS IS LOGGED {}.", (Object)j);
            ++i;
        }
        return (System.nanoTime() - start) / (long)Common.loop;
    }

    static void configure(String file) throws JoranException {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)loggerContext);
        loggerContext.reset();
        jc.doConfigure(file);
    }

    private static void initLogbackWithoutImmediateFlush() throws JoranException {
        PerformanceComparatorLogback.configure(String.valueOf(DIR_PREFIX) + "logback_without_immediateFlush.xml");
    }

    private static void initLogbackWithImmediateFlush() throws JoranException {
        PerformanceComparatorLogback.configure(String.valueOf(DIR_PREFIX) + "logback_with_immediateFlush.xml");
    }
}

