/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.net.JMSTopicAppender;
import ch.qos.logback.classic.net.LoggingEventPreSerializationTransformer;
import ch.qos.logback.classic.net.mock.MockTopic;
import ch.qos.logback.classic.net.mock.MockTopicConnectionFactory;
import ch.qos.logback.classic.net.mock.MockTopicPublisher;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.MockInitialContext;
import ch.qos.logback.classic.util.MockInitialContextFactory;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.ObjectMessage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JMSTopicAppenderTest {
    Context context;
    JMSTopicAppender appender;
    PreSerializationTransformer<ILoggingEvent> pst = new LoggingEventPreSerializationTransformer();

    @Before
    public void setUp() throws Exception {
        this.context = new ContextBase();
        this.appender = new JMSTopicAppender();
        this.appender.setContext(this.context);
        this.appender.setName("jmsTopic");
        this.appender.tcfBindingName = "topicCnxFactory";
        this.appender.topicBindingName = "testTopic";
        this.appender.setProviderURL("url");
        this.appender.setInitialContextFactoryName(MockInitialContextFactory.class.getName());
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put(this.appender.tcfBindingName, new MockTopicConnectionFactory());
        mic.map.put(this.appender.topicBindingName, new MockTopic(this.appender.topicBindingName));
    }

    @After
    public void tearDown() throws Exception {
        this.appender = null;
        this.context = null;
    }

    @Test
    public void testAppendOk() {
        this.appender.start();
        ILoggingEvent le = this.createLoggingEvent();
        this.appender.append(le);
        MockTopicPublisher tp = (MockTopicPublisher)this.appender.topicPublisher;
        Assert.assertEquals((long)1L, (long)tp.getMessageList().size());
        ObjectMessage message = (ObjectMessage)tp.getMessageList().get(0);
        try {
            Serializable witness = this.pst.transform((Object)le);
            Assert.assertEquals((Object)witness, (Object)message.getObject());
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    @Test
    public void testAppendFailure() {
        this.appender.start();
        this.appender.topicPublisher = null;
        ILoggingEvent le = this.createLoggingEvent();
        int i = 1;
        while (i <= 3) {
            this.appender.append(le);
            Assert.assertEquals((long)i, (long)this.context.getStatusManager().getCount());
            Assert.assertTrue((boolean)this.appender.isStarted());
            ++i;
        }
        this.appender.append(le);
        Assert.assertEquals((long)4L, (long)this.context.getStatusManager().getCount());
        Assert.assertFalse((boolean)this.appender.isStarted());
    }

    @Test
    public void testBuildEnvProperties() {
        this.appender.setInitialContextFactoryName("icfn");
        this.appender.setProviderURL("url");
        this.appender.setURLPkgPrefixes("pkgPref");
        this.appender.setSecurityPrincipalName("user");
        this.appender.setSecurityCredentials("cred");
        Properties props = this.appender.buildEnvProperties();
        Assert.assertEquals((long)5L, (long)props.size());
        Assert.assertEquals((Object)this.appender.getInitialContextFactoryName(), (Object)props.getProperty("java.naming.factory.initial"));
        Assert.assertEquals((Object)this.appender.getProviderURL(), (Object)props.getProperty("java.naming.provider.url"));
        Assert.assertEquals((Object)this.appender.getURLPkgPrefixes(), (Object)props.getProperty("java.naming.factory.url.pkgs"));
        Assert.assertEquals((Object)this.appender.getSecurityPrincipalName(), (Object)props.getProperty("java.naming.security.principal"));
        Assert.assertEquals((Object)this.appender.getSecurityCredentials(), (Object)props.getProperty("java.naming.security.credentials"));
    }

    @Test
    public void testBuildEnvPropertiesWithNullProviderURL() {
        this.appender.setInitialContextFactoryName("icfn");
        this.appender.setProviderURL(null);
        this.appender.setURLPkgPrefixes("pkgPref");
        this.appender.setSecurityPrincipalName("user");
        this.appender.setSecurityCredentials("cred");
        Properties props = this.appender.buildEnvProperties();
        Assert.assertEquals((long)4L, (long)props.size());
        Assert.assertEquals((Object)this.appender.getInitialContextFactoryName(), (Object)props.getProperty("java.naming.factory.initial"));
        Assert.assertEquals(null, (Object)props.getProperty("java.naming.provider.url"));
        Assert.assertEquals((Object)this.appender.getURLPkgPrefixes(), (Object)props.getProperty("java.naming.factory.url.pkgs"));
        Assert.assertEquals((Object)this.appender.getSecurityPrincipalName(), (Object)props.getProperty("java.naming.security.principal"));
        Assert.assertEquals((Object)this.appender.getSecurityCredentials(), (Object)props.getProperty("java.naming.security.credentials"));
        Assert.assertEquals((long)1L, (long)this.context.getStatusManager().getCount());
    }

    @Test
    public void testBuildEnvPropertiesWithNullCredentials() {
        this.appender.setInitialContextFactoryName("icfn");
        this.appender.setProviderURL("url");
        this.appender.setURLPkgPrefixes("pkgPref");
        this.appender.setSecurityPrincipalName("user");
        this.appender.setSecurityCredentials(null);
        Properties props = this.appender.buildEnvProperties();
        Assert.assertEquals((long)4L, (long)props.size());
        Assert.assertEquals((Object)this.appender.getInitialContextFactoryName(), (Object)props.getProperty("java.naming.factory.initial"));
        Assert.assertEquals((Object)this.appender.getProviderURL(), (Object)props.getProperty("java.naming.provider.url"));
        Assert.assertEquals((Object)this.appender.getURLPkgPrefixes(), (Object)props.getProperty("java.naming.factory.url.pkgs"));
        Assert.assertEquals((Object)this.appender.getSecurityPrincipalName(), (Object)props.getProperty("java.naming.security.principal"));
        Assert.assertEquals(null, (Object)props.getProperty("java.naming.security.credentials"));
        Assert.assertEquals((long)1L, (long)this.context.getStatusManager().getCount());
    }

    @Test
    public void testBuildEnvPropertiesWithPkgNull() {
        this.appender.setInitialContextFactoryName("icfn");
        this.appender.setProviderURL("url");
        this.appender.setURLPkgPrefixes(null);
        this.appender.setSecurityPrincipalName("user");
        this.appender.setSecurityCredentials("cred");
        Properties props = this.appender.buildEnvProperties();
        Assert.assertEquals((long)4L, (long)props.size());
        Assert.assertEquals((Object)this.appender.getInitialContextFactoryName(), (Object)props.getProperty("java.naming.factory.initial"));
        Assert.assertEquals((Object)this.appender.getProviderURL(), (Object)props.getProperty("java.naming.provider.url"));
        Assert.assertEquals(null, (Object)props.getProperty("java.naming.factory.url.pkgs"));
        Assert.assertEquals((Object)this.appender.getSecurityPrincipalName(), (Object)props.getProperty("java.naming.security.principal"));
        Assert.assertEquals((Object)this.appender.getSecurityCredentials(), (Object)props.getProperty("java.naming.security.credentials"));
        Assert.assertEquals((long)0L, (long)this.context.getStatusManager().getCount());
    }

    @Test
    public void testStartMinimalInfo() {
        this.appender.setProviderURL(null);
        this.appender.start();
        Assert.assertTrue((boolean)this.appender.isStarted());
        try {
            Assert.assertEquals((Object)this.appender.topicBindingName, (Object)this.appender.topicPublisher.getTopic().getTopicName());
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    @Test
    public void testStartUserPass() {
        this.appender.setUserName("test");
        this.appender.setPassword("test");
        this.appender.start();
        Assert.assertTrue((boolean)this.appender.isStarted());
        try {
            Assert.assertEquals((Object)this.appender.topicBindingName, (Object)this.appender.topicPublisher.getTopic().getTopicName());
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    @Test
    public void testStartFails() {
        this.appender.topicBindingName = null;
        this.appender.start();
        Assert.assertFalse((boolean)this.appender.isStarted());
    }

    private ILoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent();
        le.setLevel(Level.DEBUG);
        le.setMessage("test message");
        le.setTimeStamp(System.currentTimeMillis());
        le.setThreadName(Thread.currentThread().getName());
        return le;
    }
}

