/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import org.junit.Assert;
import org.junit.Test;

public class TargetLengthBasedClassNameAbbreviatorTest {
    @Test
    public void testShortName() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(100);
        String name = "hello";
        Assert.assertEquals((Object)name, (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(100);
        name = "hello.world";
        Assert.assertEquals((Object)name, (Object)abbreviator.abbreviate(name));
    }

    @Test
    public void testNoDot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        String name = "hello";
        Assert.assertEquals((Object)name, (Object)abbreviator.abbreviate(name));
    }

    @Test
    public void testOneDot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        String name = "hello.world";
        Assert.assertEquals((Object)"h.world", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "h.world";
        Assert.assertEquals((Object)"h.world", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = ".world";
        Assert.assertEquals((Object)".world", (Object)abbreviator.abbreviate(name));
    }

    @Test
    public void testTwoDot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        String name = "com.logback.Foobar";
        Assert.assertEquals((Object)"c.l.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "c.logback.Foobar";
        Assert.assertEquals((Object)"c.l.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "c..Foobar";
        Assert.assertEquals((Object)"c..Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "..Foobar";
        Assert.assertEquals((Object)"..Foobar", (Object)abbreviator.abbreviate(name));
    }

    @Test
    public void test3Dot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        String name = "com.logback.xyz.Foobar";
        Assert.assertEquals((Object)"c.l.x.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(13);
        name = "com.logback.xyz.Foobar";
        Assert.assertEquals((Object)"c.l.x.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(14);
        name = "com.logback.xyz.Foobar";
        Assert.assertEquals((Object)"c.l.xyz.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(15);
        name = "com.logback.alligator.Foobar";
        Assert.assertEquals((Object)"c.l.a.Foobar", (Object)abbreviator.abbreviate(name));
    }

    @Test
    public void testXDot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(21);
        String name = "com.logback.wombat.alligator.Foobar";
        Assert.assertEquals((Object)"c.l.w.a.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(22);
        name = "com.logback.wombat.alligator.Foobar";
        Assert.assertEquals((Object)"c.l.w.alligator.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "com.logback.wombat.alligator.tomato.Foobar";
        Assert.assertEquals((Object)"c.l.w.a.t.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(21);
        name = "com.logback.wombat.alligator.tomato.Foobar";
        Assert.assertEquals((Object)"c.l.w.a.tomato.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(29);
        name = "com.logback.wombat.alligator.tomato.Foobar";
        Assert.assertEquals((Object)"c.l.w.alligator.tomato.Foobar", (Object)abbreviator.abbreviate(name));
    }
}

