/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    static LoggerContext lc = new LoggerContext();

    public static void main(String[] args) throws Exception {
        long start = System.nanoTime();
        Logger logger = Main.withSLF4J();
        logger.info("hey");
        long end = System.nanoTime();
        long diff = (end - start) / 1000L / 1000L;
        System.out.println("elapsed time in milli-seconds " + diff);
    }

    private static void loop() {
        int i = 0;
        while (i < 10000) {
            PatternLayout pl = new PatternLayout();
            pl.setContext((Context)lc);
            pl.setPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
            pl.start();
            ++i;
        }
    }

    private static Logger withSLF4J() {
        System.out.println("with SLF4J");
        Logger logger = LoggerFactory.getLogger((String)"a");
        return logger;
    }

    private static Logger withoutSLF4J() throws JoranException {
        System.out.println("without SLF4J");
        LoggerContext lc = new LoggerContext();
        new ContextInitializer(lc).autoConfig();
        ch.qos.logback.classic.Logger logger = new LoggerContext().getLogger("a");
        return logger;
    }
}

