/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.lbclassic135;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.issue.lbclassic135.LoggingRunnable;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.contention.ThreadedThroughputCalculator;
import ch.qos.logback.core.encoder.Encoder;

public class LoggingToFileThroughput {
    static int THREAD_COUNT = 1;
    static long OVERALL_DURATION_IN_MILLIS = 5000L;

    public static void main(String[] args) throws InterruptedException {
        ThreadedThroughputCalculator tp = new ThreadedThroughputCalculator(OVERALL_DURATION_IN_MILLIS);
        tp.printEnvironmentInfo("lbclassic135  LoggingToFileThrouhput");
        LoggerContext lc = new LoggerContext();
        Logger logger = LoggingToFileThroughput.buildLoggerContext(lc);
        for (int i = 0; i < 2; ++i) {
            tp.execute((RunnableWithCounterAndDone[])LoggingToFileThroughput.buildArray(logger));
        }
        tp.execute((RunnableWithCounterAndDone[])LoggingToFileThroughput.buildArray(logger));
        tp.printThroughput("File:   ");
        lc.stop();
    }

    static Logger buildLoggerContext(LoggerContext lc) {
        Logger root = lc.getLogger("ROOT");
        PatternLayoutEncoder patternLayout = new PatternLayoutEncoder();
        patternLayout.setContext((Context)lc);
        patternLayout.setPattern("%d %l [%t] - %msg%n");
        patternLayout.start();
        FileAppender fileAppender = new FileAppender();
        fileAppender.setContext((Context)lc);
        fileAppender.setFile("target/lbclassic135.log");
        fileAppender.setEncoder((Encoder)patternLayout);
        fileAppender.setAppend(false);
        fileAppender.start();
        root.addAppender((Appender)fileAppender);
        return lc.getLogger(LoggingToFileThroughput.class);
    }

    static LoggingRunnable[] buildArray(Logger logger) {
        LoggingRunnable[] array = new LoggingRunnable[THREAD_COUNT];
        for (int i = 0; i < THREAD_COUNT; ++i) {
            array[i] = new LoggingRunnable((org.slf4j.Logger)logger);
        }
        return array;
    }
}

