/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.conditional;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class ConditionalTest {
    LoggerContext context = new LoggerContext();
    Logger root = this.context.getLogger("ROOT");
    int diff = RandomUtil.getPositiveInt();
    String randomOutputDir = "target/test-output/" + this.diff + "/";

    @Before
    public void setUp() throws UnknownHostException {
        this.context.setName("c" + this.diff);
        this.context.putProperty("randomOutputDir", this.randomOutputDir);
    }

    @After
    public void tearDown() {
        StatusPrinter.printIfErrorsOccured((Context)this.context);
    }

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.context);
        jc.doConfigure(file);
    }

    @Test
    public void conditionalConsoleApp_IF_THEN_True() throws JoranException, IOException, InterruptedException {
        InetAddress localhost = InetAddress.getLocalHost();
        System.out.println("In conditionalConsoleApp_IF_THEN_True, canonicalHostName=\"" + localhost.getCanonicalHostName() + "] and hostNmae=\"" + localhost.getHostName() + "\"");
        this.context.putProperty("aHost", localhost.getHostName());
        String configFileAsStr = "src/test/input/joran/conditional/conditionalConsoleApp.xml";
        this.configure(configFileAsStr);
        FileAppender fileAppender = (FileAppender)this.root.getAppender("FILE");
        Assert.assertNotNull((Object)fileAppender);
        ConsoleAppender consoleAppender = (ConsoleAppender)this.root.getAppender("CON");
        Assert.assertNotNull((Object)consoleAppender);
        StatusChecker checker = new StatusChecker((Context)this.context);
        checker.assertIsErrorFree();
    }

    @Test
    public void conditionalConsoleApp_IF_THEN_False() throws JoranException, IOException, InterruptedException {
        String configFileAsStr = "src/test/input/joran/conditional/conditionalConsoleApp.xml";
        this.configure(configFileAsStr);
        FileAppender fileAppender = (FileAppender)this.root.getAppender("FILE");
        Assert.assertNotNull((Object)fileAppender);
        ConsoleAppender consoleAppender = (ConsoleAppender)this.root.getAppender("CON");
        Assert.assertNull((Object)consoleAppender);
        StatusChecker checker = new StatusChecker((Context)this.context);
        checker.assertIsErrorFree();
    }

    @Test
    public void conditionalConsoleApp_IF_THEN_ELSE() throws JoranException, IOException, InterruptedException {
        String configFileAsStr = "src/test/input/joran/conditional/conditionalConsoleApp_ELSE.xml";
        this.configure(configFileAsStr);
        FileAppender fileAppender = (FileAppender)this.root.getAppender("FILE");
        Assert.assertNotNull((Object)fileAppender);
        ConsoleAppender consoleAppender = (ConsoleAppender)this.root.getAppender("CON");
        Assert.assertNull((Object)consoleAppender);
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertNotNull((Object)listAppender);
        StatusChecker checker = new StatusChecker((Context)this.context);
        checker.assertIsErrorFree();
    }

    @Test
    public void conditionalInclusionWithExistingFile() throws JoranException, IOException, InterruptedException {
        String configFileAsStr = "src/test/input/joran/conditional/conditionalIncludeExistingFile.xml";
        this.configure(configFileAsStr);
        StatusPrinter.print((Context)this.context);
        ConsoleAppender consoleAppender = (ConsoleAppender)this.root.getAppender("CON");
        Assert.assertNotNull((Object)consoleAppender);
        StatusChecker checker = new StatusChecker((Context)this.context);
        checker.assertIsErrorFree();
    }

    @Test
    public void conditionalInclusionWithInexistentFile() throws JoranException, IOException, InterruptedException {
        String configFileAsStr = "src/test/input/joran/conditional/conditionalIncludeInexistentFile.xml";
        this.configure(configFileAsStr);
        ConsoleAppender consoleAppender = (ConsoleAppender)this.root.getAppender("CON");
        Assert.assertNull((Object)consoleAppender);
        StatusChecker checker = new StatusChecker((Context)this.context);
        checker.assertIsErrorFree();
    }
}

