/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.CallerDataConverter;
import ch.qos.logback.classic.pattern.ClassOfCallerConverter;
import ch.qos.logback.classic.pattern.ContextNameConverter;
import ch.qos.logback.classic.pattern.FileOfCallerConverter;
import ch.qos.logback.classic.pattern.LevelConverter;
import ch.qos.logback.classic.pattern.LineOfCallerConverter;
import ch.qos.logback.classic.pattern.LineSeparatorConverter;
import ch.qos.logback.classic.pattern.LoggerConverter;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.pattern.MethodOfCallerConverter;
import ch.qos.logback.classic.pattern.PropertyConverter;
import ch.qos.logback.classic.pattern.RelativeTimeConverter;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.pattern.ThreadConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.FormattingConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;
import org.slf4j.MarkerFactory;

public class ConverterTest {
    LoggerContext lc = new LoggerContext();
    Logger logger = this.lc.getLogger(ConverterTest.class);
    LoggingEvent le;
    List<String> optionList = new ArrayList<String>();

    LoggingEvent makeLoggingEvent(Exception ex) {
        return new LoggingEvent(FormattingConverter.class.getName(), this.logger, Level.INFO, "Some message", (Throwable)ex, null);
    }

    Exception getException(String msg, Exception cause) {
        return new Exception(msg, cause);
    }

    @Before
    public void setUp() throws Exception {
        Exception rootEx = this.getException("Innermost", null);
        Exception nestedEx = this.getException("Nested", rootEx);
        Exception ex = new Exception("Bogus exception", nestedEx);
        this.le = this.makeLoggingEvent(ex);
    }

    @Test
    public void testLineOfCaller() {
        LineOfCallerConverter converter = new LineOfCallerConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"75", (Object)buf.toString());
    }

    @Test
    public void testLevel() {
        LevelConverter converter = new LevelConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"INFO", (Object)buf.toString());
        converter = new LevelConverter();
        converter.setFormattingInfo(new FormatInfo(1, 1, true, false));
        buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"I", (Object)buf.toString());
    }

    @Test
    public void testThread() {
        ThreadConverter converter = new ThreadConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        System.out.println(buf.toString());
        String regex = "([mM]ain|pool-\\d-)([Tt]hread)?(-\\d{1,3})?";
        Assert.assertTrue((boolean)buf.toString().matches(regex));
    }

    @Test
    public void testMessage() {
        MessageConverter converter = new MessageConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"Some message", (Object)buf.toString());
    }

    @Test
    public void testLineSeparator() {
        LineSeparatorConverter converter = new LineSeparatorConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)CoreConstants.LINE_SEPARATOR, (Object)buf.toString());
    }

    @Test
    public void testException() {
        ThrowableProxyConverter converter = new ThrowableProxyConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        converter = new ThrowableProxyConverter();
        this.optionList.add("3");
        converter.setOptionList(this.optionList);
        buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
    }

    @Test
    public void testLogger() {
        LoggerConverter converter = new LoggerConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)this.getClass().getName(), (Object)buf.toString());
        converter = new LoggerConverter();
        this.optionList.add("20");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"c.q.l.c.p.ConverterTest", (Object)buf.toString());
        converter = new LoggerConverter();
        this.optionList.clear();
        this.optionList.add("0");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"ConverterTest", (Object)buf.toString());
    }

    @Test
    public void testVeryLongLoggerName() {
        LoggerConverter converter = new LoggerConverter();
        this.optionList.add("5");
        converter.setOptionList(this.optionList);
        converter.start();
        StringBuilder buf = new StringBuilder();
        char c = 'a';
        int extraParts = 3;
        int totalParts = 16 + extraParts;
        StringBuilder loggerNameBuf = new StringBuilder();
        StringBuilder witness = new StringBuilder();
        for (int i = 0; i < totalParts; ++i) {
            loggerNameBuf.append(c).append(c).append(c);
            witness.append(c);
            loggerNameBuf.append('.');
            witness.append('.');
        }
        loggerNameBuf.append("zzzzzz");
        witness.append("zzzzzz");
        this.le.setLoggerName(loggerNameBuf.toString());
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)witness.toString(), (Object)buf.toString());
    }

    @Test
    public void testClass() {
        ClassOfCallerConverter converter = new ClassOfCallerConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)this.getClass().getName(), (Object)buf.toString());
    }

    @Test
    public void testMethodOfCaller() {
        MethodOfCallerConverter converter = new MethodOfCallerConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"testMethodOfCaller", (Object)buf.toString());
    }

    @Test
    public void testFileOfCaller() {
        FileOfCallerConverter converter = new FileOfCallerConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"ConverterTest.java", (Object)buf.toString());
    }

    @Test
    public void testCallerData() {
        CallerDataConverter converter = new CallerDataConverter();
        converter.start();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        if (buf.length() < 10) {
            Assert.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.add("2");
        this.optionList.add("XXX");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuilder();
        LoggingEvent event = this.makeLoggingEvent(null);
        event.addMarker(MarkerFactory.getMarker((String)"XXX"));
        converter.write(buf, (Object)event);
        if (buf.length() < 10) {
            Assert.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.clear();
        this.optionList.add("2");
        this.optionList.add("XXX");
        this.optionList.add("*");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuilder();
        event = this.makeLoggingEvent(null);
        event.addMarker(MarkerFactory.getMarker((String)"YYY"));
        converter.write(buf, (Object)event);
        if (buf.length() < 10) {
            Assert.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.clear();
        this.optionList.add("2");
        this.optionList.add("XXX");
        this.optionList.add("+");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuilder();
        event = this.makeLoggingEvent(null);
        event.addMarker(MarkerFactory.getMarker((String)"YYY"));
        converter.write(buf, (Object)event);
        if (buf.length() < 10) {
            Assert.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.clear();
        this.optionList.add("2");
        this.optionList.add("XXX");
        this.optionList.add("*");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        if (buf.length() < 10) {
            Assert.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.clear();
        this.optionList.add("4..5");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assert.assertTrue((String)"buf is too short", (buf.length() >= 10 ? 1 : 0) != 0);
        String expectedRegex = "Caller\\+4\t at (java.base\\/)?java.lang.reflect.Method.invoke.*$";
        String actual = buf.toString();
        Assert.assertTrue((String)("actual: " + actual), (boolean)Pattern.compile(expectedRegex).matcher(actual).find());
    }

    @Test
    public void testRelativeTime() throws Exception {
        RelativeTimeConverter converter = new RelativeTimeConverter();
        StringBuilder buf0 = new StringBuilder();
        StringBuilder buf1 = new StringBuilder();
        long timestamp = System.currentTimeMillis();
        LoggingEvent e0 = this.makeLoggingEvent(null);
        e0.setTimeStamp(timestamp);
        LoggingEvent e1 = this.makeLoggingEvent(null);
        e1.setTimeStamp(timestamp);
        converter.write(buf0, (Object)e0);
        converter.write(buf1, (Object)e1);
        Assert.assertEquals((Object)buf0.toString(), (Object)buf1.toString());
    }

    @Test
    public void testSyslogStart() throws Exception {
        SyslogStartConverter converter = new SyslogStartConverter();
        this.optionList.clear();
        this.optionList.add("MAIL");
        converter.setOptionList(this.optionList);
        converter.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)event);
        String expected = "<22>";
        Assert.assertTrue((boolean)buf.toString().startsWith(expected));
    }

    @Test
    public void testMDCConverter() throws Exception {
        MDC.clear();
        MDC.put((String)"someKey", (String)"someValue");
        MDCConverter converter = new MDCConverter();
        this.optionList.clear();
        this.optionList.add("someKey");
        converter.setOptionList(this.optionList);
        converter.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        String result = converter.convert((ILoggingEvent)event);
        Assert.assertEquals((Object)"someValue", (Object)result);
    }

    @Test
    public void contextNameConverter() {
        ContextNameConverter converter = new ContextNameConverter();
        LoggerContext lcOther = new LoggerContext();
        lcOther.setName("another");
        converter.setContext((Context)lcOther);
        this.lc.setName("aValue");
        LoggingEvent event = this.makeLoggingEvent(null);
        String result = converter.convert((Object)event);
        Assert.assertEquals((Object)"aValue", (Object)result);
    }

    @Test
    public void contextProperty() {
        PropertyConverter converter = new PropertyConverter();
        converter.setContext((Context)this.lc);
        ArrayList<String> ol = new ArrayList<String>();
        ol.add("k");
        converter.setOptionList(ol);
        converter.start();
        this.lc.setName("aValue");
        this.lc.putProperty("k", "v");
        LoggingEvent event = this.makeLoggingEvent(null);
        String result = converter.convert((ILoggingEvent)event);
        Assert.assertEquals((Object)"v", (Object)result);
    }
}

