/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.KeyValuePairConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.event.KeyValuePair;

public class KeyValuePairConverterTest {
    LoggerContext lc;
    KeyValuePairConverter converter;
    LoggingEvent event;

    @Before
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.converter = new KeyValuePairConverter();
        this.converter.start();
        this.event = this.createLoggingEvent();
    }

    @After
    public void tearDown() throws Exception {
        this.lc = null;
        this.converter.stop();
        this.converter = null;
    }

    @Test
    public void testWithNullKVPList() {
        String result = this.converter.convert((ILoggingEvent)this.event);
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testWithOnelKVP() {
        this.event.addKeyValuePair(new KeyValuePair("k", (Object)"v"));
        String result = this.converter.convert((ILoggingEvent)this.event);
        Assert.assertEquals((Object)"k=\"v\"", (Object)result);
    }

    private LoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent(this.getClass().getName(), this.lc.getLogger("ROOT"), Level.DEBUG, "test message", null, null);
        return le;
    }
}

