/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.TestHelper;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.util.EnvUtil;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThrowableProxyConverterTest {
    LoggerContext lc = new LoggerContext();
    ThrowableProxyConverter tpc = new ThrowableProxyConverter();
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(this.sw);

    @Before
    public void setUp() throws Exception {
        this.tpc.setContext((Context)this.lc);
        this.tpc.start();
    }

    @After
    public void tearDown() throws Exception {
    }

    private ILoggingEvent createLoggingEvent(Throwable t) {
        return new LoggingEvent(this.getClass().getName(), this.lc.getLogger("ROOT"), Level.DEBUG, "test message", t, null);
    }

    @Test
    public void suppressed() throws InvocationTargetException, IllegalAccessException {
        Exception ex = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            Exception fooException = new Exception("Foo");
            Exception barException = new Exception("Bar");
            e.addSuppressed(fooException);
            e.addSuppressed(barException);
            ex = e;
        }
        this.verify(ex);
    }

    @Test
    public void suppressedWithCause() throws InvocationTargetException, IllegalAccessException {
        Exception ex = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            ex = new Exception("Wrapper", e);
            Exception fooException = new Exception("Foo");
            Exception barException = new Exception("Bar");
            e.addSuppressed(fooException);
            e.addSuppressed(barException);
        }
        this.verify(ex);
    }

    @Test
    public void suppressedWithSuppressed() throws Exception {
        Exception ex = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            ex = new Exception("Wrapper", e);
            Exception fooException = new Exception("Foo");
            Exception barException = new Exception("Bar");
            barException.addSuppressed(fooException);
            e.addSuppressed(barException);
        }
        this.verify(ex);
    }

    @Test
    public void smoke() {
        Exception t = new Exception("smoke");
        this.verify(t);
    }

    @Test
    public void nested() {
        Throwable t = TestHelper.makeNestedException(1);
        this.verify(t);
    }

    @Test
    public void cyclicCause() {
        if (!EnvUtil.isJDK16OrHigher()) {
            return;
        }
        Exception e = new Exception("foo");
        Exception e2 = new Exception(e);
        e.initCause(e2);
        this.verify(e);
    }

    @Test
    public void cyclicSuppressed() {
        if (!EnvUtil.isJDK16OrHigher()) {
            return;
        }
        Exception e = new Exception("foo");
        Exception e2 = new Exception(e);
        e.addSuppressed(e2);
        this.verify(e);
    }

    @Test
    public void withArgumentOfOne() throws Exception {
        Throwable t = TestHelper.makeNestedException(0);
        t.printStackTrace(this.pw);
        ILoggingEvent le = this.createLoggingEvent(t);
        List<String> optionList = Arrays.asList("1");
        this.tpc.setOptionList(optionList);
        this.tpc.start();
        String result = this.tpc.convert(le);
        BufferedReader reader = new BufferedReader(new StringReader(result));
        Assert.assertTrue((boolean)reader.readLine().contains(t.getMessage()));
        Assert.assertNotNull((Object)reader.readLine());
        Assert.assertNull((String)"Unexpected line in stack trace", (Object)reader.readLine());
    }

    @Test
    public void withShortArgument() throws Exception {
        Throwable t = TestHelper.makeNestedException(0);
        t.printStackTrace(this.pw);
        ILoggingEvent le = this.createLoggingEvent(t);
        List<String> options = Arrays.asList("short");
        this.tpc.setOptionList(options);
        this.tpc.start();
        String result = this.tpc.convert(le);
        BufferedReader reader = new BufferedReader(new StringReader(result));
        Assert.assertTrue((boolean)reader.readLine().contains(t.getMessage()));
        Assert.assertNotNull((Object)reader.readLine());
        Assert.assertNull((String)"Unexpected line in stack trace", (Object)reader.readLine());
    }

    @Test
    public void skipSelectedLine() throws Exception {
        String nameOfContainingMethod = "skipSelectedLine";
        Throwable t = TestHelper.makeNestedException(0);
        t.printStackTrace(this.pw);
        ILoggingEvent le = this.createLoggingEvent(t);
        this.tpc.setOptionList(Arrays.asList("full", nameOfContainingMethod));
        this.tpc.start();
        String result = this.tpc.convert(le);
        Assertions.assertThat((String)result).doesNotContain((CharSequence)nameOfContainingMethod);
    }

    @Test
    public void skipMultipleLines() throws Exception {
        String nameOfContainingMethod = "skipMultipleLines";
        Throwable t = TestHelper.makeNestedException(0);
        t.printStackTrace(this.pw);
        ILoggingEvent le = this.createLoggingEvent(t);
        this.tpc.setOptionList(Arrays.asList("full", nameOfContainingMethod, "junit"));
        this.tpc.start();
        String result = this.tpc.convert(le);
        Assertions.assertThat((String)result).doesNotContain((CharSequence)nameOfContainingMethod).doesNotContain((CharSequence)"junit");
    }

    @Test
    public void shouldLimitTotalLinesExcludingSkipped() throws Exception {
        Throwable t = TestHelper.makeNestedException(0);
        t.printStackTrace(this.pw);
        ILoggingEvent le = this.createLoggingEvent(t);
        this.tpc.setOptionList(Arrays.asList("3", "shouldLimitTotalLinesExcludingSkipped"));
        this.tpc.start();
        String result = this.tpc.convert(le);
        Object[] lines = result.split(CoreConstants.LINE_SEPARATOR);
        Assertions.assertThat((Object[])lines).hasSize(4);
    }

    void someMethod() throws Exception {
        throw new Exception("someMethod");
    }

    void verify(Throwable t) {
        t.printStackTrace(this.pw);
        ILoggingEvent le = this.createLoggingEvent(t);
        String result = this.tpc.convert(le);
        result = result.replace("common frames omitted", "more");
        Assert.assertEquals((Object)this.sw.toString(), (Object)result);
    }
}

