/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.rolling;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.rolling.testUtil.ScaffoldingForRollingTests;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.StatusChecker;
import ch.qos.logback.core.util.CachingDateFormatter;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class UniqueFileTest {
    static String UNIK_DIFF = "UNIK_DIFF";
    LoggerContext lc = new LoggerContext();
    StatusChecker sc = new StatusChecker((Context)this.lc);
    Logger logger = this.lc.getLogger(this.getClass());
    int diff = RandomUtil.getPositiveInt() % 1000;
    String diffAsStr = Integer.toString(this.diff);

    @Before
    public void setUp() {
        System.setProperty(UNIK_DIFF, this.diffAsStr);
    }

    @After
    public void tearDown() {
        System.clearProperty(UNIK_DIFF);
    }

    void loadConfig(String confifFile) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.lc);
        jc.doConfigure(confifFile);
    }

    @Test
    public void basic() throws Exception {
        this.loadConfig("src/test/input/joran/unique.xml");
        CachingDateFormatter sdf = new CachingDateFormatter("yyyyMMdd'T'HHmm");
        String timestamp = sdf.format(System.currentTimeMillis());
        this.sc.assertIsErrorFree();
        Logger root = this.lc.getLogger("ROOT");
        root.info("hello");
        ScaffoldingForRollingTests.existenceCheck((String)("target/test-output/UNIK_" + timestamp + this.diffAsStr + "log.txt"));
    }
}

