/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.fastdoubleparser;

import ch.randelshofer.fastdoubleparser.FastDoubleMath;

public class FastDoubleParser {
    private static final long MINIMAL_NINETEEN_DIGIT_INTEGER = 1000000000000000000L;
    private static final int MINIMAL_EIGHT_DIGIT_INTEGER = 10000000;
    private static final byte DECIMAL_POINT_CLASS = -4;
    private static final byte OTHER_CLASS = -1;
    private static final byte[] CHAR_TO_HEX_MAP;

    private FastDoubleParser() {
    }

    private static boolean isInteger(char c) {
        return '0' <= c && c <= '9';
    }

    private static NumberFormatException newNumberFormatException(CharSequence str) {
        if (str.length() > 1024) {
            return new NumberFormatException("For input string of length " + str.length());
        }
        return new NumberFormatException("For input string: \"" + str.toString().trim() + "\"");
    }

    public static double parseDouble(CharSequence str) throws NumberFormatException {
        boolean hasLeadingZero;
        boolean isNegative;
        int strlen = str.length();
        int index = FastDoubleParser.skipWhitespace(str, strlen, 0);
        if (index == strlen) {
            throw new NumberFormatException("empty String");
        }
        char ch = str.charAt(index);
        boolean bl = isNegative = ch == '-';
        if (isNegative || ch == '+') {
            char c = ch = ++index < strlen ? str.charAt(index) : (char)'\u0000';
            if (ch == '\u0000') {
                throw FastDoubleParser.newNumberFormatException(str);
            }
        }
        if (ch == 'N') {
            return FastDoubleParser.parseNaN(str, index, strlen);
        }
        if (ch == 'I') {
            return FastDoubleParser.parseInfinity(str, index, strlen, isNegative);
        }
        boolean bl2 = hasLeadingZero = ch == '0';
        if (hasLeadingZero) {
            char c = ch = ++index < strlen ? str.charAt(index) : (char)'\u0000';
            if (ch == 'x' || ch == 'X') {
                return FastDoubleParser.parseRestOfHexFloatingPointLiteral(str, index + 1, strlen, isNegative);
            }
        }
        return FastDoubleParser.parseRestOfDecimalFloatLiteral(str, strlen, index, isNegative, hasLeadingZero);
    }

    private static double parseRestOfDecimalFloatLiteral(CharSequence str, int strlen, int index, boolean isNegative, boolean hasLeadingZero) {
        boolean isDigitsTruncated;
        boolean hasExponent;
        int digitCount;
        char ch = index < strlen ? str.charAt(index) : (char)'\u0000';
        long digits = 0L;
        long exponent = 0L;
        int indexOfFirstDigit = index;
        int virtualIndexOfPoint = -1;
        while (index < strlen) {
            ch = str.charAt(index);
            if (FastDoubleParser.isInteger(ch)) {
                digits = 10L * digits + (long)ch - 48L;
            } else {
                if (ch != '.') break;
                if (virtualIndexOfPoint != -1) {
                    throw FastDoubleParser.newNumberFormatException(str);
                }
                virtualIndexOfPoint = index;
            }
            ++index;
        }
        int indexAfterDigits = index;
        if (virtualIndexOfPoint == -1) {
            digitCount = indexAfterDigits - indexOfFirstDigit;
            virtualIndexOfPoint = indexAfterDigits;
        } else {
            digitCount = indexAfterDigits - indexOfFirstDigit - 1;
            exponent = virtualIndexOfPoint - index + 1;
        }
        long exp_number = 0L;
        boolean bl = hasExponent = ch == 'e' || ch == 'E';
        if (hasExponent) {
            boolean neg_exp;
            ch = ++index < strlen ? str.charAt(index) : (char)'\u0000';
            boolean bl2 = neg_exp = ch == '-';
            if (neg_exp || ch == '+') {
                char c = ch = ++index < strlen ? str.charAt(index) : (char)'\u0000';
            }
            if (!FastDoubleParser.isInteger(ch)) {
                throw FastDoubleParser.newNumberFormatException(str);
            }
            while (FastDoubleParser.isInteger(ch)) {
                if (exp_number < 10000000L) {
                    exp_number = 10L * exp_number + (long)ch - 48L;
                }
                ch = ++index < strlen ? str.charAt(index) : (char)'\u0000';
            }
            if (neg_exp) {
                exp_number = -exp_number;
            }
            exponent += exp_number;
        }
        if ((index = FastDoubleParser.skipWhitespace(str, strlen, index)) < strlen || !hasLeadingZero && digitCount == 0 && str.charAt(virtualIndexOfPoint) != '.') {
            throw FastDoubleParser.newNumberFormatException(str);
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 19) {
            digits = 0L;
            for (index = indexOfFirstDigit; index < indexAfterDigits; ++index) {
                ch = str.charAt(index);
                if (ch == '.') {
                    ++skipCountInTruncatedDigits;
                    continue;
                }
                if (Long.compareUnsigned(digits, 1000000000000000000L) >= 0) break;
                digits = 10L * digits + (long)ch - 48L;
            }
            isDigitsTruncated = index < indexAfterDigits;
        } else {
            isDigitsTruncated = false;
        }
        Double result = FastDoubleMath.decFloatLiteralToDouble(index, isNegative, digits, exponent, virtualIndexOfPoint, exp_number, isDigitsTruncated, skipCountInTruncatedDigits);
        if (result == null) {
            return FastDoubleParser.parseRestOfDecimalFloatLiteralTheHardWay(str);
        }
        return result;
    }

    private static double parseRestOfHexFloatingPointLiteral(CharSequence str, int index, int strlen, boolean isNegative) {
        boolean isDigitsTruncated;
        boolean hasExponent;
        int digitCount;
        if (index >= strlen) {
            throw FastDoubleParser.newNumberFormatException(str);
        }
        char ch = str.charAt(index);
        long digits = 0L;
        long exponent = 0L;
        int indexOfFirstDigit = index;
        int virtualIndexOfPoint = -1;
        while (index < strlen) {
            int hexValue;
            ch = str.charAt(index);
            int n = hexValue = ch > '\u00ff' ? -1 : CHAR_TO_HEX_MAP[ch];
            if (hexValue >= 0) {
                digits = digits << 4 | (long)hexValue;
            } else {
                if (hexValue != -4) break;
                if (virtualIndexOfPoint != -1) {
                    throw FastDoubleParser.newNumberFormatException(str);
                }
                virtualIndexOfPoint = index;
            }
            ++index;
        }
        int indexAfterDigits = index;
        if (virtualIndexOfPoint == -1) {
            digitCount = indexAfterDigits - indexOfFirstDigit;
            virtualIndexOfPoint = indexAfterDigits;
        } else {
            digitCount = indexAfterDigits - indexOfFirstDigit - 1;
            exponent = (long)(virtualIndexOfPoint - index + 1) * 4L;
        }
        long exp_number = 0L;
        boolean bl = hasExponent = ch == 'p' || ch == 'P';
        if (hasExponent) {
            boolean neg_exp;
            ch = ++index < strlen ? str.charAt(index) : (char)'\u0000';
            boolean bl2 = neg_exp = ch == '-';
            if (neg_exp || ch == '+') {
                char c = ch = ++index < strlen ? str.charAt(index) : (char)'\u0000';
            }
            if (!FastDoubleParser.isInteger(ch)) {
                throw FastDoubleParser.newNumberFormatException(str);
            }
            while (FastDoubleParser.isInteger(ch)) {
                if (exp_number < 10000000L) {
                    exp_number = 10L * exp_number + (long)ch - 48L;
                }
                ch = ++index < strlen ? str.charAt(index) : (char)'\u0000';
            }
            if (neg_exp) {
                exp_number = -exp_number;
            }
            exponent += exp_number;
        }
        if ((index = FastDoubleParser.skipWhitespace(str, strlen, index)) < strlen || digitCount == 0 && str.charAt(virtualIndexOfPoint) != '.' || !hasExponent) {
            throw FastDoubleParser.newNumberFormatException(str);
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 16) {
            digits = 0L;
            for (index = indexOfFirstDigit; index < indexAfterDigits; ++index) {
                int hexValue;
                ch = str.charAt(index);
                int n = hexValue = ch > '\u007f' ? -1 : CHAR_TO_HEX_MAP[ch];
                if (hexValue >= 0) {
                    if (Long.compareUnsigned(digits, 1000000000000000000L) >= 0) break;
                    digits = digits << 4 | (long)hexValue;
                    continue;
                }
                ++skipCountInTruncatedDigits;
            }
            isDigitsTruncated = index < indexAfterDigits;
        } else {
            isDigitsTruncated = false;
        }
        return FastDoubleMath.hexFloatLiteralToDouble(str, index, isNegative, digits, exponent, virtualIndexOfPoint, exp_number, isDigitsTruncated, skipCountInTruncatedDigits);
    }

    private static double parseInfinity(CharSequence str, int index, int strlen, boolean negative) {
        if (index + 7 < strlen && str.charAt(index + 1) == 'n' && str.charAt(index + 2) == 'f' && str.charAt(index + 3) == 'i' && str.charAt(index + 4) == 'n' && str.charAt(index + 5) == 'i' && str.charAt(index + 6) == 't' && str.charAt(index + 7) == 'y') {
            if ((index = FastDoubleParser.skipWhitespace(str, strlen, index + 8)) < strlen) {
                throw FastDoubleParser.newNumberFormatException(str);
            }
            return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        throw FastDoubleParser.newNumberFormatException(str);
    }

    private static double parseNaN(CharSequence str, int index, int strlen) {
        if (index + 2 < strlen && str.charAt(index + 1) == 'a' && str.charAt(index + 2) == 'N') {
            if ((index = FastDoubleParser.skipWhitespace(str, strlen, index + 3)) < strlen) {
                throw FastDoubleParser.newNumberFormatException(str);
            }
            return Double.NaN;
        }
        throw FastDoubleParser.newNumberFormatException(str);
    }

    private static int skipWhitespace(CharSequence str, int strlen, int index) {
        while (index < strlen && str.charAt(index) <= ' ') {
            ++index;
        }
        return index;
    }

    private static double parseRestOfDecimalFloatLiteralTheHardWay(CharSequence str) {
        return Double.parseDouble(str.toString());
    }

    static {
        int ch;
        CHAR_TO_HEX_MAP = new byte[256];
        for (ch = 0; ch < CHAR_TO_HEX_MAP.length; ch = (int)((char)(ch + 1))) {
            FastDoubleParser.CHAR_TO_HEX_MAP[ch] = -1;
        }
        for (ch = 48; ch <= 57; ch = (int)((char)(ch + 1))) {
            FastDoubleParser.CHAR_TO_HEX_MAP[ch] = (byte)(ch - 48);
        }
        for (ch = 65; ch <= 70; ch = (int)((char)(ch + 1))) {
            FastDoubleParser.CHAR_TO_HEX_MAP[ch] = (byte)(ch - 65 + 10);
        }
        for (ch = 97; ch <= 102; ch = (int)((char)(ch + 1))) {
            FastDoubleParser.CHAR_TO_HEX_MAP[ch] = (byte)(ch - 97 + 10);
        }
        for (ch = 46; ch <= 46; ch = (int)((char)(ch + 1))) {
            FastDoubleParser.CHAR_TO_HEX_MAP[ch] = -4;
        }
    }
}

