/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.av;

import java.io.IOException;
import org.monte.media.av.AbstractMovie;
import org.monte.media.av.Format;
import org.monte.media.av.MovieReader;
import org.monte.media.math.Rational;

public class DefaultMovie
extends AbstractMovie {
    private static final long serialVersionUID = 1L;
    private MovieReader reader;

    @Override
    public MovieReader getReader() {
        return this.reader;
    }

    public void setReader(MovieReader reader) {
        this.reader = reader;
    }

    @Override
    public Rational getDuration() {
        try {
            return this.reader.getDuration();
        }
        catch (IOException ex) {
            InternalError ie = new InternalError("Can't read duration.");
            ie.initCause(ex);
            throw ie;
        }
    }

    @Override
    public long timeToSample(int track, Rational time) {
        try {
            return this.reader.timeToSample(track, time);
        }
        catch (IOException ex) {
            return 0L;
        }
    }

    @Override
    public Rational sampleToTime(int track, long sample) {
        try {
            return this.reader.sampleToTime(track, sample);
        }
        catch (IOException ex) {
            return new Rational(0L);
        }
    }

    @Override
    public int getTrackCount() {
        try {
            return this.reader.getTrackCount();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public Format getFormat(int track) {
        try {
            return this.reader.getFormat(track);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public Format getFileFormat() {
        try {
            return this.reader.getFileFormat();
        }
        catch (IOException ex) {
            return null;
        }
    }
}

